/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.CodecUtils;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableByIndexData;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.google.common.reflect.TypeToken;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

abstract class AbstractGettableByIndexData
implements GettableByIndexData {
    protected final ProtocolVersion protocolVersion;

    protected AbstractGettableByIndexData(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    protected abstract DataType getType(int var1);

    protected abstract String getName(int var1);

    protected abstract ByteBuffer getValue(int var1);

    protected abstract CodecRegistry getCodecRegistry();

    protected <T> TypeCodec<T> codecFor(int i) {
        return this.getCodecRegistry().codecFor(this.getType(i));
    }

    protected <T> TypeCodec<T> codecFor(int i, Class<T> javaClass) {
        return this.getCodecRegistry().codecFor(this.getType(i), javaClass);
    }

    protected <T> TypeCodec<T> codecFor(int i, TypeToken<T> javaType) {
        return this.getCodecRegistry().codecFor(this.getType(i), javaType);
    }

    protected <T> TypeCodec<T> codecFor(int i, T value) {
        return this.getCodecRegistry().codecFor(this.getType(i), value);
    }

    protected void checkType(int i, DataType.Name actual) {
        DataType.Name expected = this.getType(i).getName();
        if (!actual.isCompatibleWith(expected)) {
            throw new InvalidTypeException(String.format("Value %s is of type %s, not %s", new Object[]{this.getName(i), expected, actual}));
        }
    }

    protected void checkType(int i, DataType.Name actual1, DataType.Name actual2) {
        DataType.Name expected = this.getType(i).getName();
        if (!actual1.isCompatibleWith(expected) && !actual2.isCompatibleWith(expected)) {
            throw new InvalidTypeException(String.format("Value %s is of type %s, not any of [%s, %s]", new Object[]{this.getName(i), expected, actual1, actual2}));
        }
    }

    protected void checkType(int i, DataType.Name actual1, DataType.Name actual2, DataType.Name actual3) {
        DataType.Name expected = this.getType(i).getName();
        if (!(actual1.isCompatibleWith(expected) || actual2.isCompatibleWith(expected) || actual3.isCompatibleWith(expected))) {
            throw new InvalidTypeException(String.format("Value %s is of type %s, not any of [%s, %s, %s]", new Object[]{this.getName(i), expected, actual1, actual2, actual3}));
        }
    }

    @Override
    public boolean isNull(int i) {
        return this.getValue(i) == null;
    }

    @Override
    public boolean getBool(int i) {
        this.checkType(i, DataType.Name.BOOLEAN);
        ByteBuffer value = this.getValue(i);
        if (value == null || value.remaining() == 0) {
            return false;
        }
        TypeCodec<Class<Boolean>> codec = this.codecFor(i, (Object)Boolean.class);
        if (codec instanceof TypeCodec.PrimitiveBooleanCodec) {
            return ((TypeCodec.PrimitiveBooleanCodec)((Object)codec)).deserializeNoBoxing(value, this.protocolVersion);
        }
        return (Boolean)((Object)codec.deserialize(value, this.protocolVersion));
    }

    @Override
    public byte getByte(int i) {
        this.checkType(i, DataType.Name.TINYINT);
        ByteBuffer value = this.getValue(i);
        TypeCodec<Class<Byte>> codec = this.codecFor(i, (Object)Byte.class);
        if (codec instanceof TypeCodec.PrimitiveByteCodec) {
            return ((TypeCodec.PrimitiveByteCodec)((Object)codec)).deserializeNoBoxing(value, this.protocolVersion);
        }
        return (Byte)((Object)codec.deserialize(value, this.protocolVersion));
    }

    @Override
    public short getShort(int i) {
        this.checkType(i, DataType.Name.SMALLINT);
        ByteBuffer value = this.getValue(i);
        TypeCodec<Class<Short>> codec = this.codecFor(i, (Object)Short.class);
        if (codec instanceof TypeCodec.PrimitiveShortCodec) {
            return ((TypeCodec.PrimitiveShortCodec)((Object)codec)).deserializeNoBoxing(value, this.protocolVersion);
        }
        return (Short)((Object)codec.deserialize(value, this.protocolVersion));
    }

    @Override
    public int getInt(int i) {
        this.checkType(i, DataType.Name.INT);
        ByteBuffer value = this.getValue(i);
        TypeCodec<Class<Integer>> codec = this.codecFor(i, (Object)Integer.class);
        if (codec instanceof TypeCodec.PrimitiveIntCodec) {
            return ((TypeCodec.PrimitiveIntCodec)((Object)codec)).deserializeNoBoxing(value, this.protocolVersion);
        }
        return (Integer)((Object)codec.deserialize(value, this.protocolVersion));
    }

    @Override
    public long getLong(int i) {
        this.checkType(i, DataType.Name.BIGINT, DataType.Name.COUNTER);
        ByteBuffer value = this.getValue(i);
        TypeCodec<Class<Long>> codec = this.codecFor(i, (Object)Long.class);
        if (codec instanceof TypeCodec.PrimitiveLongCodec) {
            return ((TypeCodec.PrimitiveLongCodec)((Object)codec)).deserializeNoBoxing(value, this.protocolVersion);
        }
        return (Long)((Object)codec.deserialize(value, this.protocolVersion));
    }

    @Override
    public Date getTimestamp(int i) {
        this.checkType(i, DataType.Name.TIMESTAMP);
        ByteBuffer value = this.getValue(i);
        return (Date)((Object)this.codecFor(i, (Object)Date.class).deserialize(value, this.protocolVersion));
    }

    @Override
    public LocalDate getDate(int i) {
        this.checkType(i, DataType.Name.DATE);
        ByteBuffer value = this.getValue(i);
        return (LocalDate)((Object)this.codecFor(i, (Object)LocalDate.class).deserialize(value, this.protocolVersion));
    }

    @Override
    public long getTime(int i) {
        this.checkType(i, DataType.Name.TIME);
        ByteBuffer value = this.getValue(i);
        TypeCodec<Class<Long>> codec = this.codecFor(i, (Object)Long.class);
        if (codec instanceof TypeCodec.PrimitiveLongCodec) {
            return ((TypeCodec.PrimitiveLongCodec)((Object)codec)).deserializeNoBoxing(value, this.protocolVersion);
        }
        return (Long)((Object)codec.deserialize(value, this.protocolVersion));
    }

    @Override
    public float getFloat(int i) {
        this.checkType(i, DataType.Name.FLOAT);
        ByteBuffer value = this.getValue(i);
        TypeCodec<Class<Float>> codec = this.codecFor(i, (Object)Float.class);
        if (codec instanceof TypeCodec.PrimitiveFloatCodec) {
            return ((TypeCodec.PrimitiveFloatCodec)((Object)codec)).deserializeNoBoxing(value, this.protocolVersion);
        }
        return ((Float)((Object)codec.deserialize(value, this.protocolVersion))).floatValue();
    }

    @Override
    public double getDouble(int i) {
        this.checkType(i, DataType.Name.DOUBLE);
        ByteBuffer value = this.getValue(i);
        TypeCodec<Class<Double>> codec = this.codecFor(i, (Object)Double.class);
        if (codec instanceof TypeCodec.PrimitiveDoubleCodec) {
            return ((TypeCodec.PrimitiveDoubleCodec)((Object)codec)).deserializeNoBoxing(value, this.protocolVersion);
        }
        return (Double)((Object)codec.deserialize(value, this.protocolVersion));
    }

    @Override
    public ByteBuffer getBytesUnsafe(int i) {
        ByteBuffer value = this.getValue(i);
        if (value == null) {
            return null;
        }
        return value.duplicate();
    }

    @Override
    public ByteBuffer getBytes(int i) {
        this.checkType(i, DataType.Name.BLOB);
        ByteBuffer value = this.getValue(i);
        return (ByteBuffer)((Object)this.codecFor(i, (Object)ByteBuffer.class).deserialize(value, this.protocolVersion));
    }

    @Override
    public String getString(int i) {
        this.checkType(i, DataType.Name.VARCHAR, DataType.Name.ASCII);
        ByteBuffer value = this.getValue(i);
        return (String)((Object)this.codecFor(i, (Object)String.class).deserialize(value, this.protocolVersion));
    }

    @Override
    public BigInteger getVarint(int i) {
        this.checkType(i, DataType.Name.VARINT);
        ByteBuffer value = this.getValue(i);
        return (BigInteger)((Object)this.codecFor(i, (Object)BigInteger.class).deserialize(value, this.protocolVersion));
    }

    @Override
    public BigDecimal getDecimal(int i) {
        this.checkType(i, DataType.Name.DECIMAL);
        ByteBuffer value = this.getValue(i);
        return (BigDecimal)((Object)this.codecFor(i, (Object)BigDecimal.class).deserialize(value, this.protocolVersion));
    }

    @Override
    public UUID getUUID(int i) {
        this.checkType(i, DataType.Name.UUID, DataType.Name.TIMEUUID);
        ByteBuffer value = this.getValue(i);
        return (UUID)((Object)this.codecFor(i, (Object)UUID.class).deserialize(value, this.protocolVersion));
    }

    @Override
    public InetAddress getInet(int i) {
        this.checkType(i, DataType.Name.INET);
        ByteBuffer value = this.getValue(i);
        return (InetAddress)((Object)this.codecFor(i, (Object)InetAddress.class).deserialize(value, this.protocolVersion));
    }

    @Override
    public <T> List<T> getList(int i, Class<T> elementsClass) {
        return this.getList(i, TypeToken.of(elementsClass));
    }

    @Override
    public <T> List<T> getList(int i, TypeToken<T> elementsType) {
        this.checkType(i, DataType.Name.LIST);
        ByteBuffer value = this.getValue(i);
        TypeToken<List<T>> javaType = CodecUtils.listOf(elementsType);
        return (List)this.codecFor(i, (T)javaType).deserialize(value, this.protocolVersion);
    }

    @Override
    public <T> Set<T> getSet(int i, Class<T> elementsClass) {
        return this.getSet(i, TypeToken.of(elementsClass));
    }

    @Override
    public <T> Set<T> getSet(int i, TypeToken<T> elementsType) {
        this.checkType(i, DataType.Name.SET);
        ByteBuffer value = this.getValue(i);
        TypeToken<Set<T>> javaType = CodecUtils.setOf(elementsType);
        return (Set)this.codecFor(i, (T)javaType).deserialize(value, this.protocolVersion);
    }

    @Override
    public <K, V> Map<K, V> getMap(int i, Class<K> keysClass, Class<V> valuesClass) {
        return this.getMap(i, TypeToken.of(keysClass), TypeToken.of(valuesClass));
    }

    @Override
    public <K, V> Map<K, V> getMap(int i, TypeToken<K> keysType, TypeToken<V> valuesType) {
        this.checkType(i, DataType.Name.MAP);
        ByteBuffer value = this.getValue(i);
        TypeToken<Map<K, V>> javaType = CodecUtils.mapOf(keysType, valuesType);
        return (Map)this.codecFor(i, (Object)javaType).deserialize(value, this.protocolVersion);
    }

    @Override
    public UDTValue getUDTValue(int i) {
        this.checkType(i, DataType.Name.UDT);
        ByteBuffer value = this.getValue(i);
        return (UDTValue)((Object)this.codecFor(i, (Object)UDTValue.class).deserialize(value, this.protocolVersion));
    }

    @Override
    public TupleValue getTupleValue(int i) {
        this.checkType(i, DataType.Name.TUPLE);
        ByteBuffer value = this.getValue(i);
        return (TupleValue)((Object)this.codecFor(i, (Object)TupleValue.class).deserialize(value, this.protocolVersion));
    }

    @Override
    public Object getObject(int i) {
        return this.get(i, this.codecFor(i));
    }

    @Override
    public <T> T get(int i, Class<T> targetClass) {
        return (T)this.get(i, this.codecFor(i, (T)targetClass));
    }

    @Override
    public <T> T get(int i, TypeToken<T> targetType) {
        return (T)this.get(i, this.codecFor(i, (T)targetType));
    }

    @Override
    public <T> T get(int i, TypeCodec<T> codec) {
        this.checkType(i, codec.getCqlType().getName());
        ByteBuffer value = this.getValue(i);
        return codec.deserialize(value, this.protocolVersion);
    }
}

