package com.dahuatech.icc.common;

/**
 * program:java-sdk
 */
public enum ParamValidEnum {
    /************************ 鉴权信息错误码 ************************/
    //参数为空
    OAUTH_PARAM_NOT_EMPTY_ERROR("OPENAPI_1001","The oauth parameter is not null"),



    /************************ 接口信息错误码 ************************/
    //参数为空
    PARAM_NOT_EMPTY_ERROR("OPENAPI_1002","The parameter is not null"),

    //对于枚举类型，参数不在范围校验
    PARAM_SCOP_ERROR("OPENAPI_1002", "The parameter is not within the specified range"),

    //对于指定格式，如身份号、邮箱等，正则表达式校验错误
    PARAM_FORMAT_ERROR("OPENAPI_1002", "The parameter format does not meet the requirements"),

    ;
    private String code;
    private String errMsg;

    ParamValidEnum(String code, String errMsg){
        this.code = code;
        this.errMsg = errMsg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }
}
