package com.dahuatech.hutool.log.dialect.tinylog;

import com.dahuatech.hutool.log.Log;
import com.dahuatech.hutool.log.LogFactory;

/**
 * <a href="http://www.tinylog.org/">TinyLog</a> log.<br>
 *
 * @author Looly
 */
public class TinyLogFactory extends LogFactory {

  /** 构造 */
  public TinyLogFactory() {
    super("TinyLog");
    checkLogExist(org.pmw.tinylog.Logger.class);
  }

  @Override
  public Log createLog(String name) {
    return new com.dahuatech.hutool.log.dialect.tinylog.TinyLog(name);
  }

  @Override
  public Log createLog(Class<?> clazz) {
    return new TinyLog(clazz);
  }
}
