/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting;

import com.carrotsearch.randomizedtesting.ClassGlobFilter;
import com.carrotsearch.randomizedtesting.ClassModel;
import com.carrotsearch.randomizedtesting.Classes;
import com.carrotsearch.randomizedtesting.CloseableResourceInfo;
import com.carrotsearch.randomizedtesting.GroupEvaluator;
import com.carrotsearch.randomizedtesting.InstanceProvider;
import com.carrotsearch.randomizedtesting.InternalAssumptionViolatedException;
import com.carrotsearch.randomizedtesting.JUnit4MethodProvider;
import com.carrotsearch.randomizedtesting.LifecycleScope;
import com.carrotsearch.randomizedtesting.MethodGlobFilter;
import com.carrotsearch.randomizedtesting.MurmurHash3;
import com.carrotsearch.randomizedtesting.ObjectProcedure;
import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.Randomness;
import com.carrotsearch.randomizedtesting.ResourceDisposalError;
import com.carrotsearch.randomizedtesting.Rethrow;
import com.carrotsearch.randomizedtesting.RunnerThreadGroup;
import com.carrotsearch.randomizedtesting.SeedDecorator;
import com.carrotsearch.randomizedtesting.SeedUtils;
import com.carrotsearch.randomizedtesting.SysGlobals;
import com.carrotsearch.randomizedtesting.TestMethodProvider;
import com.carrotsearch.randomizedtesting.ThreadLeakControl;
import com.carrotsearch.randomizedtesting.Threads;
import com.carrotsearch.randomizedtesting.TraceFormatting;
import com.carrotsearch.randomizedtesting.Validation;
import com.carrotsearch.randomizedtesting.annotations.Listeners;
import com.carrotsearch.randomizedtesting.annotations.Name;
import com.carrotsearch.randomizedtesting.annotations.ParametersFactory;
import com.carrotsearch.randomizedtesting.annotations.Repeat;
import com.carrotsearch.randomizedtesting.annotations.Seed;
import com.carrotsearch.randomizedtesting.annotations.SeedDecorators;
import com.carrotsearch.randomizedtesting.annotations.Seeds;
import com.carrotsearch.randomizedtesting.annotations.TestMethodProviders;
import com.carrotsearch.randomizedtesting.annotations.Timeout;
import com.carrotsearch.randomizedtesting.rules.StatementAdapter;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public final class RandomizedRunner
extends Runner
implements Filterable {
    public static final String AUGMENTED_SEED_PACKAGE = "__randomizedtesting";
    public static final int DEFAULT_TIMEOUT = 0;
    public static final int DEFAULT_TIMEOUT_SUITE = 0;
    public static final int DEFAULT_KILLATTEMPTS = 5;
    public static final int DEFAULT_KILLWAIT = 500;
    public static final int DEFAULT_ITERATIONS = 1;
    static final Logger logger = Logger.getLogger(RandomizedRunner.class.getSimpleName());
    private static final AtomicLong sequencer = new AtomicLong();
    private static final List<String> DEFAULT_STACK_FILTERS = Arrays.asList("org.junit.", "junit.framework.", "sun.", "java.lang.reflect.", "com.carrotsearch.randomizedtesting.");
    private final Class<?> suiteClass;
    final Randomness runnerRandomness;
    private Randomness testCaseRandomnessOverride;
    private final Integer iterationsOverride;
    private List<TestCandidate> testCandidates;
    private Description suiteDescription;
    private List<Filter> suiteFilters = new ArrayList<Filter>();
    private List<Filter> testFilters = new ArrayList<Filter>();
    RunnerThreadGroup runnerThreadGroup;
    private final List<RunListener> autoListeners = new ArrayList<RunListener>();
    private boolean appendSeedParameter;
    private final TraceFormatting traces;
    private RunnerContainer containerRunner;
    QueueUncaughtExceptionsHandler handler;
    private ClassModel classModel;
    private Map<Class<? extends Annotation>, List<Method>> shuffledMethodsCache = new HashMap<Class<? extends Annotation>, List<Method>>();
    static AtomicBoolean zombieMarker = new AtomicBoolean(false);
    static final ThreadGroup mainThreadGroup = Thread.currentThread().getThreadGroup();
    private final Map<String, String> restoreProperties = new HashMap<String, String>();
    public GroupEvaluator groupEvaluator;

    public RandomizedRunner(Class<?> testClass) throws InitializationError {
        long initialSeed;
        this.appendSeedParameter = RandomizedTest.systemPropertyAsBoolean(SysGlobals.SYSPROP_APPEND_SEED(), false);
        this.traces = RandomizedTest.systemPropertyAsBoolean(SysGlobals.SYSPROP_STACKFILTERING(), true) ? new TraceFormatting(DEFAULT_STACK_FILTERS) : new TraceFormatting();
        this.suiteClass = testClass;
        this.classModel = new ClassModel(testClass);
        this.containerRunner = RandomizedRunner.detectContainer();
        ArrayList<SeedDecorator> decorators = new ArrayList<SeedDecorator>();
        for (SeedDecorators decAnn : RandomizedRunner.getAnnotationsFromClassHierarchy(testClass, SeedDecorators.class)) {
            for (Class<? extends SeedDecorator> clazz : decAnn.value()) {
                try {
                    SeedDecorator dec = clazz.newInstance();
                    dec.initialize(testClass);
                    decorators.add(dec);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Could not initialize suite class: " + testClass.getName() + " because its @SeedDecorators contains non-instantiable: " + clazz.getName(), t);
                }
            }
        }
        SeedDecorator[] decArray = decorators.toArray(new SeedDecorator[decorators.size()]);
        long randomSeed = MurmurHash3.hash(sequencer.getAndIncrement() + System.nanoTime());
        String globalSeed = RandomizedRunner.emptyToNull(System.getProperty(SysGlobals.SYSPROP_RANDOM_SEED()));
        if (globalSeed != null) {
            long[] seedChain = SeedUtils.parseSeedChain(globalSeed);
            if (seedChain.length == 0 || seedChain.length > 2) {
                throw new IllegalArgumentException("Invalid system property " + SysGlobals.SYSPROP_RANDOM_SEED() + " specification: " + globalSeed);
            }
            if (seedChain.length > 1) {
                this.testCaseRandomnessOverride = new Randomness(seedChain[1], new SeedDecorator[0]);
            }
            initialSeed = seedChain[0];
        } else {
            initialSeed = this.suiteClass.isAnnotationPresent(Seed.class) ? this.seedFromAnnot(this.suiteClass, randomSeed)[0] : randomSeed;
        }
        this.runnerRandomness = new Randomness(initialSeed, decArray);
        if (RandomizedRunner.emptyToNull(System.getProperty(SysGlobals.SYSPROP_ITERATIONS())) != null) {
            this.iterationsOverride = RandomizedTest.systemPropertyAsInt(SysGlobals.SYSPROP_ITERATIONS(), 0);
            if (this.iterationsOverride < 1) {
                throw new IllegalArgumentException("System property " + SysGlobals.SYSPROP_ITERATIONS() + " must be >= 1: " + this.iterationsOverride);
            }
        } else {
            this.iterationsOverride = null;
        }
        try {
            this.validateTarget();
            this.suiteDescription = Description.createSuiteDescription(this.suiteClass);
            this.testCandidates = this.collectTestCandidates(this.suiteDescription);
            this.groupEvaluator = new GroupEvaluator(this.testCandidates);
        }
        catch (Throwable t) {
            throw new InitializationError(t);
        }
    }

    private static RunnerContainer detectContainer() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length > 0) {
            String topClass = stack[stack.length - 1].getClassName();
            if (topClass.equals("org.eclipse.jdt.internal.junit.runner.RemoteTestRunner")) {
                return RunnerContainer.ECLIPSE;
            }
            if (topClass.startsWith("com.intellij.")) {
                return RunnerContainer.IDEA;
            }
        }
        return RunnerContainer.UNKNOWN;
    }

    public Description getDescription() {
        return this.suiteDescription;
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        this.testFilters.add(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        this.processSystemProperties();
        try {
            this.runSuite(notifier);
        }
        finally {
            this.restoreSystemProperties();
        }
    }

    private void restoreSystemProperties() {
        for (Map.Entry<String, String> e : this.restoreProperties.entrySet()) {
            if (e.getValue() == null) {
                System.clearProperty(e.getKey());
                continue;
            }
            System.setProperty(e.getKey(), e.getValue());
        }
    }

    private void processSystemProperties() {
        if (RandomizedRunner.emptyToNull(System.getProperty(SysGlobals.SYSPROP_TESTCLASS())) != null) {
            this.suiteFilters.add(new ClassGlobFilter(System.getProperty(SysGlobals.SYSPROP_TESTCLASS())));
        }
        if (RandomizedRunner.emptyToNull(System.getProperty(SysGlobals.SYSPROP_TESTMETHOD())) != null) {
            this.testFilters.add(new MethodGlobFilter(System.getProperty(SysGlobals.SYSPROP_TESTMETHOD())));
        }
        if (RandomizedRunner.emptyToNull(System.getProperty("junit4.childvm.count")) == null && RandomizedRunner.emptyToNull(System.getProperty("junit4.childvm.id")) == null) {
            this.restoreProperties.put("junit4.childvm.count", System.getProperty("junit4.childvm.count"));
            this.restoreProperties.put("junit4.childvm.id", System.getProperty("junit4.childvm.id"));
            System.setProperty("junit4.childvm.count", "1");
            System.setProperty("junit4.childvm.id", "0");
        }
    }

    private void runSuite(final RunNotifier notifier) {
        Thread.UncaughtExceptionHandler previous = Thread.getDefaultUncaughtExceptionHandler();
        this.handler = new QueueUncaughtExceptionsHandler();
        Thread.setDefaultUncaughtExceptionHandler(this.handler);
        this.runnerThreadGroup = new RunnerThreadGroup("TGRP-" + Classes.simpleName(this.suiteClass));
        Thread runner = new Thread(this.runnerThreadGroup, "SUITE-" + Classes.simpleName(this.suiteClass) + "-seed#" + SeedUtils.formatSeedChain(this.runnerRandomness)){

            @Override
            public void run() {
                try {
                    try {
                        Class.forName(RandomizedRunner.this.suiteClass.getName(), true, RandomizedRunner.this.suiteClass.getClassLoader());
                    }
                    catch (ExceptionInInitializerError e) {
                        throw e.getCause();
                    }
                    RandomizedContext context = RandomizedRunner.this.createContext(RandomizedRunner.this.runnerThreadGroup);
                    RandomizedRunner.this.runSuite(context, notifier);
                    context.dispose();
                }
                catch (Throwable t) {
                    notifier.fireTestFailure(new Failure(RandomizedRunner.this.suiteDescription, t));
                }
            }
        };
        runner.start();
        try {
            runner.join();
        }
        catch (InterruptedException e) {
            notifier.fireTestFailure(new Failure(this.suiteDescription, (Throwable)new RuntimeException("Interrupted while waiting for the suite runner? Weird.", e)));
        }
        if (Thread.getDefaultUncaughtExceptionHandler() != this.handler) {
            notifier.fireTestFailure(new Failure(this.suiteDescription, (Throwable)new RuntimeException("Suite replaced Thread.defaultUncaughtExceptionHandler. It's better not to touch it. Or at least revert it to what it was before. Current: " + Thread.getDefaultUncaughtExceptionHandler().getClass())));
        }
        Thread.setDefaultUncaughtExceptionHandler(previous);
        this.runnerThreadGroup = null;
        this.handler = null;
    }

    private void runSuite(RandomizedContext context, RunNotifier notifier) {
        RunListener accounting;
        Result result;
        block16: {
            result = new Result();
            accounting = result.createListener();
            notifier.addListener(accounting);
            Randomness classRandomness = this.runnerRandomness.clone(Thread.currentThread());
            context.push(classRandomness);
            try {
                this.subscribeListeners(notifier);
                for (RunListener r : this.autoListeners) {
                    try {
                        r.testRunStarted(this.suiteDescription);
                    }
                    catch (Throwable e) {
                        logger.log(Level.SEVERE, "Panic: RunListener hook shouldn't throw exceptions.", e);
                    }
                }
                List<TestCandidate> filtered = this.getFilteredTestCandidates();
                GroupEvaluator evaluator = RandomizedContext.current().getGroupEvaluator();
                if (evaluator.hasFilteringExpression()) {
                    Iterator<TestCandidate> i = filtered.iterator();
                    while (i.hasNext()) {
                        TestCandidate c = i.next();
                        if (evaluator.isTestIgnored(c.method, this.suiteClass) == null) continue;
                        i.remove();
                    }
                }
                if (filtered.isEmpty()) break block16;
                if (this.areAllRemainingIgnored(filtered)) {
                    for (TestCandidate candidate : filtered) {
                        if (this.isTestIgnored(notifier, candidate)) continue;
                        throw new RuntimeException("Should not reach here.");
                    }
                    break block16;
                }
                ThreadLeakControl threadLeakControl = new ThreadLeakControl(notifier, this);
                Statement s = this.runTestsStatement(threadLeakControl.notifier(), filtered, threadLeakControl);
                s = this.withClassBefores(s);
                s = this.withClassAfters(s);
                s = this.withClassRules(s);
                s = RandomizedRunner.withCloseContextResources(s, LifecycleScope.SUITE);
                s = threadLeakControl.forSuite(s, this.suiteDescription);
                try {
                    s.evaluate();
                }
                catch (Throwable t) {
                    t = RandomizedRunner.augmentStackTrace(t, this.runnerRandomness);
                    if (t instanceof AssumptionViolatedException) {
                        notifier.fireTestAssumptionFailed(new Failure(this.suiteDescription, t));
                        for (TestCandidate c : filtered) {
                            notifier.fireTestIgnored(c.description);
                        }
                        break block16;
                    }
                    this.fireTestFailure(notifier, this.suiteDescription, t);
                }
            }
            catch (Throwable t) {
                notifier.fireTestFailure(new Failure(this.suiteDescription, t));
            }
        }
        for (RunListener r : this.autoListeners) {
            try {
                r.testRunFinished(result);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Panic: RunListener hook shouldn't throw exceptions.", e);
            }
        }
        notifier.removeListener(accounting);
        this.unsubscribeListeners(notifier);
        context.popAndDestroy();
    }

    private boolean areAllRemainingIgnored(List<TestCandidate> filtered) {
        RunNotifier fake = new RunNotifier();
        for (TestCandidate candidate : filtered) {
            if (this.isTestIgnored(fake, candidate)) continue;
            return false;
        }
        return true;
    }

    private static Statement withCloseContextResources(Statement s, final LifecycleScope scope) {
        return new StatementAdapter(s){

            @Override
            protected void afterAlways(final List<Throwable> errors) throws Throwable {
                ObjectProcedure<CloseableResourceInfo> disposer = new ObjectProcedure<CloseableResourceInfo>(){

                    @Override
                    public void apply(CloseableResourceInfo info) {
                        try {
                            info.getResource().close();
                        }
                        catch (Throwable t) {
                            ResourceDisposalError e = new ResourceDisposalError("Resource in scope " + info.getScope().name() + " failed to close. Resource was" + " registered from thread " + info.getThreadName() + ", registration stack trace below.", t);
                            e.setStackTrace(info.getAllocationStack());
                            errors.add(e);
                        }
                    }
                };
                RandomizedContext.current().closeResources(disposer, scope);
            }
        };
    }

    private Statement runTestsStatement(final RunNotifier notifier, final List<TestCandidate> filtered, final ThreadLeakControl threadLeakControl) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                for (TestCandidate c : filtered) {
                    if (RandomizedRunner.this.isTestIgnored(notifier, c)) continue;
                    String testThreadName = "TEST-" + Classes.simpleName(RandomizedRunner.this.suiteClass) + "." + c.method.getName() + "-seed#" + SeedUtils.formatSeedChain(RandomizedRunner.this.runnerRandomness);
                    String restoreName = Thread.currentThread().getName();
                    RandomizedContext current = RandomizedContext.current();
                    try {
                        Thread.currentThread().setName(testThreadName);
                        current.push(new Randomness(c.seed, new SeedDecorator[0]));
                        RandomizedRunner.this.runSingleTest(notifier, c, threadLeakControl);
                    }
                    finally {
                        Thread.currentThread().setName(restoreName);
                        current.popAndDestroy();
                    }
                }
            }
        };
    }

    private void fireTestFailure(RunNotifier notifier, Description description, Throwable t) {
        if (t instanceof MultipleFailureException) {
            for (Throwable nested : ((MultipleFailureException)t).getFailures()) {
                this.fireTestFailure(notifier, description, nested);
            }
        } else {
            notifier.fireTestFailure(new Failure(description, t));
        }
    }

    private Statement withClassBefores(final Statement s) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    for (Method method : RandomizedRunner.this.getShuffledMethods(BeforeClass.class)) {
                        RandomizedRunner.this.invoke(method, null, new Object[0]);
                    }
                }
                catch (Throwable t) {
                    throw RandomizedRunner.augmentStackTrace(t, RandomizedRunner.this.runnerRandomness);
                }
                s.evaluate();
            }
        };
    }

    private Statement withClassAfters(final Statement s) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                try {
                    s.evaluate();
                }
                catch (Throwable t) {
                    errors.add(RandomizedRunner.augmentStackTrace(t, RandomizedRunner.this.runnerRandomness));
                }
                for (Method method : RandomizedRunner.this.getShuffledMethods(AfterClass.class)) {
                    try {
                        RandomizedRunner.this.invoke(method, null, new Object[0]);
                    }
                    catch (Throwable t) {
                        errors.add(RandomizedRunner.augmentStackTrace(t, RandomizedRunner.this.runnerRandomness));
                    }
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    private Statement withClassRules(Statement s) {
        List<TestRule> classRules = this.getAnnotatedFieldValues(null, ClassRule.class, TestRule.class);
        for (TestRule rule : classRules) {
            s = rule.apply(s, this.suiteDescription);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runSingleTest(RunNotifier notifier, final TestCandidate c, ThreadLeakControl threadLeakControl) {
        notifier.fireTestStarted(c.description);
        try {
            final Object instance = c.instanceProvider.newInstance();
            Statement s = new Statement(){

                public void evaluate() throws Throwable {
                    RandomizedRunner.this.invoke(c.method, instance, new Object[0]);
                }
            };
            s = this.wrapExpectedExceptions(s, c);
            s = this.wrapBeforeAndAfters(s, c, instance);
            s = this.wrapMethodRules(s, c, instance);
            s = RandomizedRunner.withCloseContextResources(s, LifecycleScope.TEST);
            s = threadLeakControl.forTest(s, c);
            s.evaluate();
        }
        catch (Throwable e) {
            e = RandomizedRunner.augmentStackTrace(e, new Randomness[0]);
            if (e instanceof AssumptionViolatedException) {
                notifier.fireTestAssumptionFailed(new Failure(c.description, e));
            } else {
                this.fireTestFailure(notifier, c.description, e);
            }
        }
        finally {
            notifier.fireTestFinished(c.description);
        }
    }

    private Statement wrapBeforeAndAfters(Statement s, TestCandidate c, final Object instance) {
        List<Method> afters;
        final List<Method> befores = this.getShuffledMethods(Before.class);
        if (!befores.isEmpty()) {
            final Statement afterBefores = s;
            s = new Statement(){

                public void evaluate() throws Throwable {
                    for (Method m : befores) {
                        RandomizedRunner.this.invoke(m, instance, new Object[0]);
                    }
                    afterBefores.evaluate();
                }
            };
        }
        if (!(afters = this.getShuffledMethods(After.class)).isEmpty()) {
            final Statement afterAfters = s;
            s = new Statement(){

                public void evaluate() throws Throwable {
                    ArrayList<Throwable> cumulative = new ArrayList<Throwable>();
                    try {
                        afterAfters.evaluate();
                    }
                    catch (Throwable t) {
                        cumulative.add(t);
                    }
                    for (Method m : afters) {
                        try {
                            RandomizedRunner.this.invoke(m, instance, new Object[0]);
                        }
                        catch (Throwable t) {
                            cumulative.add(t);
                        }
                    }
                    if (cumulative.size() == 1) {
                        throw (Throwable)cumulative.get(0);
                    }
                    if (cumulative.size() > 1) {
                        throw new MultipleFailureException(cumulative);
                    }
                }
            };
        }
        return s;
    }

    private Statement wrapExpectedExceptions(final Statement s, TestCandidate c) {
        Test ann = c.method.getAnnotation(Test.class);
        if (ann == null) {
            return s;
        }
        final Class expectedClass = ann.expected();
        if (expectedClass.getName().equals("org.junit.Test$None")) {
            return s;
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    s.evaluate();
                }
                catch (Throwable t) {
                    if (!expectedClass.isInstance(t)) {
                        throw t;
                    }
                    return;
                }
                Assert.fail((String)("Expected an exception but the test passed: " + expectedClass.getName()));
            }
        };
    }

    private Statement wrapMethodRules(Statement s, TestCandidate c, Object instance) {
        FrameworkMethod fm = new FrameworkMethod(c.method);
        List<MethodRule> methodRules = this.getAnnotatedFieldValues(instance, Rule.class, MethodRule.class);
        for (MethodRule rule : methodRules) {
            s = rule.apply(s, fm, instance);
        }
        List<TestRule> testRules = this.getAnnotatedFieldValues(instance, Rule.class, TestRule.class);
        for (TestRule rule : testRules) {
            s = rule.apply(s, c.description);
        }
        return s;
    }

    private <T> List<T> getAnnotatedFieldValues(Object test, Class<? extends Annotation> annotationClass, Class<T> valueClass) {
        TestClass info = new TestClass(this.suiteClass);
        ArrayList<T> results = new ArrayList<T>();
        ArrayList annotatedFields = new ArrayList(info.getAnnotatedFields(annotationClass));
        HashMap byClass = new HashMap();
        for (FrameworkField field : annotatedFields) {
            Class<?> clz = field.getField().getDeclaringClass();
            if (!byClass.containsKey(clz)) {
                byClass.put(clz, new ArrayList());
            }
            ((List)byClass.get(clz)).add(field);
        }
        for (List fields : byClass.values()) {
            Collections.sort(fields, new Comparator<FrameworkField>(){

                @Override
                public int compare(FrameworkField o1, FrameworkField o2) {
                    return o1.getField().getName().compareTo(o2.getField().getName());
                }
            });
            Collections.shuffle(fields, new Random(this.runnerRandomness.getSeed()));
        }
        annotatedFields.clear();
        for (Class<?> clz = this.suiteClass; clz != null; clz = clz.getSuperclass()) {
            List clzFields = (List)byClass.get(clz);
            if (clzFields == null) continue;
            annotatedFields.addAll(clzFields);
        }
        for (FrameworkField each : annotatedFields) {
            try {
                Object fieldValue = each.get(test);
                if (!valueClass.isInstance(fieldValue)) continue;
                results.add(valueClass.cast(fieldValue));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return results;
    }

    private RandomizedContext createContext(ThreadGroup tg) {
        return RandomizedContext.create(tg, this.suiteClass, this);
    }

    private void subscribeListeners(RunNotifier notifier) {
        for (Listeners ann : RandomizedRunner.getAnnotationsFromClassHierarchy(this.suiteClass, Listeners.class)) {
            for (Class<? extends RunListener> clazz : ann.value()) {
                try {
                    RunListener listener = clazz.newInstance();
                    this.autoListeners.add(listener);
                    notifier.addListener(listener);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Could not initialize suite class: " + this.suiteClass.getName() + " because its @Listener is not instantiable: " + clazz.getName(), t);
                }
            }
        }
    }

    private void unsubscribeListeners(RunNotifier notifier) {
        for (RunListener r : this.autoListeners) {
            notifier.removeListener(r);
        }
    }

    private List<TestCandidate> getFilteredTestCandidates() {
        if (!this.suiteFilters.isEmpty()) {
            for (Filter f : this.suiteFilters) {
                if (f.shouldRun(this.suiteDescription)) continue;
                return Collections.emptyList();
            }
        }
        if (this.testFilters.isEmpty()) {
            return this.testCandidates;
        }
        ArrayList<TestCandidate> filtered = new ArrayList<TestCandidate>(this.testCandidates);
        Iterator i = filtered.iterator();
        block1: while (i.hasNext()) {
            TestCandidate candidate = (TestCandidate)i.next();
            for (Filter f : this.testFilters) {
                if (f.shouldRun(candidate.description) || f.shouldRun(Description.createTestDescription(candidate.instanceProvider.getTestClass(), (String)candidate.method.getName()))) continue;
                i.remove();
                continue block1;
            }
        }
        if (this.testCandidates.size() > 0 && filtered.isEmpty()) {
            boolean expandedCandidates = this.candidatesWithRandomSeeds(this.testCandidates);
            boolean filtersIncludeSeed = this.filtersIncludeSeed(this.testFilters);
            if (expandedCandidates && filtersIncludeSeed) {
                Logger.getAnonymousLogger().warning("Empty set of tests for suite class " + this.suiteClass.getSimpleName() + " after filters applied. This can be caused by an attempt to filter tests with a random" + " or fixed seed different than the filter's. Use the same constant seed " + "(-Dtests.seed=deadbeef) to get a reproducible (and filterable)" + " set of tests.");
            }
            if (expandedCandidates && !filtersIncludeSeed) {
                String warningMessage = "Empty set of tests for suite class " + this.suiteClass.getSimpleName() + " after filters applied.";
                warningMessage = RandomizedRunner.emptyToNull(System.getProperty(SysGlobals.SYSPROP_TESTMETHOD())) != null ? warningMessage + " Your method filter property should be a glob pattern to cater for the random seed appended to each expanded test repetition. Use -D" + SysGlobals.SYSPROP_TESTMETHOD() + "=" + System.getProperty(SysGlobals.SYSPROP_TESTMETHOD()) + "*" : warningMessage + " This can be caused by an attempt to filter tests by fixed method name when their repetitions are expanded with a random seed to make their names unique. Use a globbing pattern in your filters to ignore anything after the method name, for example: -D" + SysGlobals.SYSPROP_TESTMETHOD() + "=method*";
                Logger.getAnonymousLogger().warning(warningMessage);
            }
        }
        return filtered;
    }

    private boolean filtersIncludeSeed(List<Filter> filters) {
        for (Filter f : filters) {
            if (!this.hasSeedPattern(f.describe())) continue;
            return true;
        }
        return false;
    }

    private boolean hasSeedPattern(String description) {
        Pattern p = Pattern.compile("seed=\\[");
        return p.matcher(description).find();
    }

    private boolean candidatesWithRandomSeeds(List<TestCandidate> testCandidates) {
        for (TestCandidate tc : testCandidates) {
            if (!this.hasSeedPattern(tc.description.getMethodName())) continue;
            return true;
        }
        return false;
    }

    static String emptyToNull(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        return value.trim();
    }

    private boolean isTestIgnored(RunNotifier notifier, TestCandidate c) {
        if (c.method.getAnnotation(Ignore.class) != null) {
            notifier.fireTestIgnored(c.description);
            return true;
        }
        GroupEvaluator evaluator = RandomizedContext.current().getGroupEvaluator();
        String reasonIgnored = evaluator.isTestIgnored(c.method, this.suiteClass);
        if (reasonIgnored != null) {
            notifier.fireTestStarted(c.description);
            if (this.containerRunner != RunnerContainer.IDEA) {
                notifier.fireTestIgnored(c.description);
            }
            notifier.fireTestAssumptionFailed(new Failure(c.description, (Throwable)((Object)new InternalAssumptionViolatedException(reasonIgnored))));
            notifier.fireTestFinished(c.description);
            return true;
        }
        return false;
    }

    private List<Method> getShuffledMethods(Class<? extends Annotation> ann) {
        List<Method> methods = this.shuffledMethodsCache.get(ann);
        if (methods != null) {
            return methods;
        }
        methods = new ArrayList<Method>(this.classModel.getAnnotatedLeafMethods(ann).keySet());
        Random rnd = new Random(this.runnerRandomness.getSeed());
        int i = 0;
        int j = 0;
        while (i < methods.size()) {
            Method m = methods.get(i);
            for (j = i + 1; j < methods.size() && m.getDeclaringClass() == methods.get(j).getDeclaringClass(); ++j) {
            }
            if (j - i > 1) {
                Collections.shuffle(methods.subList(i, j), rnd);
            }
            i = j;
        }
        if (ann == Before.class || ann == BeforeClass.class) {
            Collections.reverse(methods);
        }
        methods = Collections.unmodifiableList(methods);
        this.shuffledMethodsCache.put(ann, methods);
        return methods;
    }

    private List<TestCandidate> collectTestCandidates(Description classDescription) {
        TestMethodProvider[] providers;
        TestMethodProviders providersAnnotation = this.suiteClass.getAnnotation(TestMethodProviders.class);
        if (providersAnnotation != null) {
            providers = new TestMethodProvider[providersAnnotation.value().length];
            int i = 0;
            for (Class<? extends TestMethodProvider> clazz : providersAnnotation.value()) {
                try {
                    providers[i++] = (TestMethodProvider)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(TestMethodProviders.class.getSimpleName() + " classes could not be instantiated.", e);
                }
            }
        } else {
            providers = new TestMethodProvider[]{new JUnit4MethodProvider()};
        }
        HashSet<Method> allTestMethods = new HashSet<Method>();
        for (TestMethodProvider provider : providers) {
            Collection<Method> testMethods = provider.getTestMethods(this.suiteClass, this.classModel);
            allTestMethods.addAll(testMethods);
        }
        ArrayList<Method> testMethods = new ArrayList<Method>(allTestMethods);
        Collections.sort(testMethods, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                return m1.toGenericString().compareTo(m2.toGenericString());
            }
        });
        this.validateTestMethods(testMethods);
        Collections.shuffle(testMethods, new Random(this.runnerRandomness.getSeed()));
        Constructor<?> constructor = this.suiteClass.getConstructors()[0];
        ArrayList<Object> parameters = new ArrayList<Object[]>();
        if (constructor.getParameterTypes().length == 0) {
            parameters.add(new Object[0]);
        } else {
            try {
                parameters = this.collectFactoryParameters();
            }
            catch (AssumptionViolatedException e) {
                return Collections.emptyList();
            }
        }
        ArrayList<TestCandidate> allTests = new ArrayList<TestCandidate>();
        HashMap<Method, Description> subNodes = new HashMap<Method, Description>();
        if (parameters.size() > 1) {
            for (Method method : testMethods) {
                Description tmp = Description.createSuiteDescription((String)method.getName(), (Annotation[])new Annotation[0]);
                subNodes.put(method, tmp);
                this.suiteDescription.addChild(tmp);
            }
        }
        String[] parameterNames = new String[constructor.getParameterTypes().length];
        Annotation[][] anns = constructor.getParameterAnnotations();
        for (int i = 0; i < parameterNames.length; ++i) {
            for (Annotation ann : anns[i]) {
                if (ann == null || !ann.annotationType().equals(Name.class)) continue;
                parameterNames[i] = ((Name)ann).value() + "=";
                break;
            }
            if (parameterNames[i] != null) continue;
            parameterNames[i] = "p" + i + "=";
        }
        for (Object[] objectArray : parameters) {
            LinkedHashMap<String, Object> parameterizedArgs = new LinkedHashMap<String, Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                parameterizedArgs.put(i < parameterNames.length ? parameterNames[i] : "p" + i + "=", objectArray[i]);
            }
            for (Method method : testMethods) {
                List<TestCandidate> methodTests = this.collectCandidatesForMethod(constructor, objectArray, method, parameterizedArgs);
                Description tmp = (Description)subNodes.get(method);
                if (tmp == null && methodTests.size() > 1) {
                    tmp = Description.createSuiteDescription((String)method.getName(), (Annotation[])new Annotation[0]);
                    subNodes.put(method, tmp);
                    this.suiteDescription.addChild(tmp);
                } else if (tmp == null) {
                    tmp = this.suiteDescription;
                }
                Description parent = tmp;
                for (TestCandidate c : methodTests) {
                    parent.addChild(c.description);
                    allTests.add(c);
                }
            }
        }
        return allTests;
    }

    private List<TestCandidate> collectCandidatesForMethod(final Constructor<?> constructor, final Object[] params, Method method, LinkedHashMap<String, Object> parameterizedArgs) {
        ArrayList<TestCandidate> candidates = new ArrayList<TestCandidate>();
        boolean fixedSeed = this.isConstantSeedForAllIterations(method);
        int methodIterations = this.determineMethodIterationCount(method);
        long[] seeds = this.determineMethodSeeds(method);
        boolean hasRepetitions = methodIterations > 1 || seeds.length > 1;
        int repetition = 0;
        for (long testSeed : seeds) {
            int i = 0;
            while (i < methodIterations) {
                long thisSeed = fixedSeed ? testSeed : testSeed ^ MurmurHash3.hash((long)i);
                LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
                if (hasRepetitions) {
                    args.put("#", repetition);
                }
                args.putAll(parameterizedArgs);
                if (hasRepetitions || this.appendSeedParameter) {
                    args.put("seed=", SeedUtils.formatSeedChain(this.runnerRandomness, new Randomness(thisSeed, new SeedDecorator[0])));
                }
                Description description = Description.createSuiteDescription((String)String.format("%s%s(%s)", method.getName(), this.formatMethodArgs(args), this.suiteClass.getName()), (Annotation[])method.getAnnotations());
                candidates.add(new TestCandidate(method, thisSeed, description, new InstanceProvider(){

                    @Override
                    public Object newInstance() throws Throwable {
                        try {
                            return constructor.newInstance(params);
                        }
                        catch (InvocationTargetException e) {
                            throw e.getTargetException();
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException("Constructor arguments do not match provider parameters?", e);
                        }
                    }

                    @Override
                    public Class<?> getTestClass() {
                        return RandomizedRunner.this.suiteClass;
                    }
                }));
                ++i;
                ++repetition;
            }
        }
        return candidates;
    }

    private String formatMethodArgs(LinkedHashMap<String, Object> args) {
        if (args.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append(" {");
        Iterator<Map.Entry<String, Object>> i = args.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Object> e = i.next();
            b.append(e.getKey()).append(this.toString(e.getValue()));
            if (!i.hasNext()) continue;
            b.append(" ");
        }
        b.append("}");
        return b.toString();
    }

    private String toString(Object value) {
        if (value == null) {
            return "null";
        }
        return value.toString();
    }

    public ArrayList<Object[]> collectFactoryParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (Method m : this.classModel.getAnnotatedLeafMethods(ParametersFactory.class).keySet()) {
            Validation.checkThat(m).isStatic().isPublic();
            ParametersFactory pfAnnotation = m.getAnnotation(ParametersFactory.class);
            assert (pfAnnotation != null);
            if (!Iterable.class.isAssignableFrom(m.getReturnType())) {
                throw new RuntimeException("@" + ParametersFactory.class.getSimpleName() + " annotated " + "methods must be public, static and returning Iterable<Object[]>:" + m);
            }
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            try {
                for (Object[] p : (Iterable)m.invoke(null, new Object[0])) {
                    result.add(p);
                }
            }
            catch (InvocationTargetException e) {
                Rethrow.rethrow(e.getCause());
            }
            catch (Throwable t) {
                throw new RuntimeException("Error collecting parameters from: " + m, t);
            }
            if (result.isEmpty()) {
                throw new InternalAssumptionViolatedException("Parameters set should not be empty. Ignoring tests.");
            }
            if (pfAnnotation.shuffle()) {
                Collections.shuffle(result, new Random(this.runnerRandomness.getSeed()));
            }
            parameters.addAll(result);
        }
        return parameters;
    }

    private boolean isConstantSeedForAllIterations(Method method) {
        if (this.testCaseRandomnessOverride != null) {
            return true;
        }
        Repeat repeat = method.getAnnotation(Repeat.class);
        if (repeat != null) {
            return repeat.useConstantSeed();
        }
        repeat = this.suiteClass.getAnnotation(Repeat.class);
        if (repeat != null) {
            return repeat.useConstantSeed();
        }
        return false;
    }

    private int determineMethodIterationCount(Method method) {
        if (this.iterationsOverride != null) {
            return this.iterationsOverride;
        }
        Repeat repeat = method.getAnnotation(Repeat.class);
        if (repeat != null) {
            return repeat.iterations();
        }
        repeat = this.suiteClass.getAnnotation(Repeat.class);
        if (repeat != null) {
            return repeat.iterations();
        }
        return 1;
    }

    private long[] determineMethodSeeds(Method method) {
        long[] seedChain;
        Seeds seedsValue;
        if (this.testCaseRandomnessOverride != null) {
            return new long[]{this.testCaseRandomnessOverride.getSeed()};
        }
        long randomSeed = this.runnerRandomness.getSeed() ^ MurmurHash3.hash((long)method.getName().hashCode());
        HashSet<Long> seeds = new HashSet<Long>();
        Seed seed = method.getAnnotation(Seed.class);
        if (seed != null) {
            for (long s : this.seedFromAnnot(method, randomSeed)) {
                seeds.add(s);
            }
        }
        if ((seedsValue = this.classModel.getAnnotation(method, Seeds.class, true)) != null) {
            for (Seed seed2 : seedsValue.value()) {
                if (seed2.value().equals("random")) {
                    seeds.add(randomSeed);
                    continue;
                }
                for (long s2 : SeedUtils.parseSeedChain(seed2.value())) {
                    seeds.add(s2);
                }
            }
        }
        if (seeds.isEmpty() && (seed = this.suiteClass.getAnnotation(Seed.class)) != null && !seed.value().equals("random") && (seedChain = SeedUtils.parseSeedChain(this.suiteClass.getAnnotation(Seed.class).value())).length > 1) {
            seeds.add(seedChain[1]);
        }
        if (seeds.isEmpty()) {
            seeds.add(randomSeed);
        }
        long[] result = new long[seeds.size()];
        int i = 0;
        for (Long l : seeds) {
            result[i++] = l;
        }
        return result;
    }

    void invoke(Method m, Object instance, Object ... args) throws Throwable {
        if (!Modifier.isPublic(m.getModifiers())) {
            try {
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
            }
            catch (SecurityException e) {
                throw new RuntimeException("There is a non-public method that needs to be called. This requires ReflectPermission('suppressAccessChecks'). Don't run with the security manager or  add this permission to the runner. Offending method: " + m.toGenericString());
            }
        }
        try {
            m.invoke(instance, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private void validateTestMethods(List<Method> testMethods) {
        HashSet parents = new HashSet();
        for (Class<?> c = this.suiteClass; c != null; c = c.getSuperclass()) {
            parents.add(c);
        }
        for (Method method : testMethods) {
            if (!parents.contains(method.getDeclaringClass())) {
                throw new IllegalArgumentException("Test method does not belong to test suite class hierarchy: " + method.getDeclaringClass() + "#" + method.getName());
            }
            Validation.checkThat(method).describedAs("Test method " + this.suiteClass.getName() + "#" + method.getName()).isPublic().isNotStatic().hasArgsCount(0);
            Test testAnn = this.classModel.getAnnotation(method, Test.class, true);
            if (testAnn != null && testAnn.timeout() > 0L && this.classModel.isAnnotationPresent(method, Timeout.class, true)) {
                throw new IllegalArgumentException("Conflicting @Test(timeout=...) and @Timeout annotations in: " + this.suiteClass.getName() + "#" + method.getName());
            }
            Seed seed = this.classModel.getAnnotation(method, Seed.class, true);
            if (seed == null) continue;
            try {
                long[] chain;
                String seedChain = seed.value();
                if (seedChain.equals("random") || (chain = SeedUtils.parseSeedChain(seedChain)).length <= 1) continue;
                throw new IllegalArgumentException("@Seed on methods must contain one seed only (no runner seed).");
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("@Seed annotation invalid on method " + method.getName() + ", in class " + this.suiteClass.getName() + ": " + e.getMessage());
            }
        }
    }

    private void validateTarget() {
        Validation.checkThat(this.suiteClass).describedAs("Suite class " + this.suiteClass.getName()).isPublic().isConcreteClass();
        Constructor<?>[] constructors = this.suiteClass.getConstructors();
        if (constructors.length != 1 || !Modifier.isPublic(constructors[0].getModifiers())) {
            throw new RuntimeException("A test class is expected to have one public constructor  (parameterless or with types matching static @" + ParametersFactory.class + "-annotated method's output): " + this.suiteClass.getName());
        }
        if (constructors[0].getParameterTypes().length > 0) {
            Set<Method> factories = this.classModel.getAnnotatedLeafMethods(ParametersFactory.class).keySet();
            if (factories.isEmpty()) {
                throw new RuntimeException("A test class with a parameterized constructor is expected  to have a static @" + ParametersFactory.class + "-annotated method: " + this.suiteClass.getName());
            }
            for (Method m : factories) {
                Validation.checkThat(m).describedAs("@ParametersFactory method " + this.suiteClass.getName() + "#" + m.getName()).isStatic().isPublic().hasArgsCount(0).hasReturnType(Iterable.class);
            }
        }
        for (Method method : this.classModel.getAnnotatedLeafMethods(BeforeClass.class).keySet()) {
            Validation.checkThat(method).describedAs("@BeforeClass method " + this.suiteClass.getName() + "#" + method.getName()).isStatic().hasArgsCount(0);
        }
        for (Method method : this.classModel.getAnnotatedLeafMethods(AfterClass.class).keySet()) {
            Validation.checkThat(method).describedAs("@AfterClass method " + this.suiteClass.getName() + "#" + method.getName()).isStatic().hasArgsCount(0);
        }
        for (Method method : this.classModel.getAnnotatedLeafMethods(Before.class).keySet()) {
            Validation.checkThat(method).describedAs("@Before method " + this.suiteClass.getName() + "#" + method.getName()).isNotStatic().hasArgsCount(0);
        }
        for (Method method : this.classModel.getAnnotatedLeafMethods(After.class).keySet()) {
            Validation.checkThat(method).describedAs("@After method " + this.suiteClass.getName() + "#" + method.getName()).isNotStatic().hasArgsCount(0);
        }
    }

    static <T extends Throwable> T augmentStackTrace(T e, Randomness ... seeds) {
        if (seeds.length == 0) {
            seeds = RandomizedContext.current().getRandomnesses();
        }
        String seedChain = SeedUtils.formatSeedChain(seeds);
        String existingSeed = RandomizedRunner.seedFromThrowable(e);
        if (existingSeed != null && existingSeed.equals(seedChain)) {
            return e;
        }
        ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>(Arrays.asList(e.getStackTrace()));
        stack.add(0, new StackTraceElement("__randomizedtesting.SeedInfo", "seed", seedChain, 0));
        e.setStackTrace(stack.toArray(new StackTraceElement[stack.size()]));
        return e;
    }

    private static <T extends Annotation> List<T> getAnnotationsFromClassHierarchy(Class<?> clazz, Class<T> annotation) {
        ArrayList<T> anns = new ArrayList<T>();
        IdentityHashMap<T, T> inherited = new IdentityHashMap<T, T>();
        for (Class<?> c = clazz; c != Object.class; c = c.getSuperclass()) {
            T ann;
            if (!c.isAnnotationPresent(annotation) || (ann = c.getAnnotation(annotation)).annotationType().isAnnotationPresent(Inherited.class) && inherited.containsKey(ann)) continue;
            anns.add(ann);
            inherited.put(ann, ann);
        }
        Collections.reverse(anns);
        return anns;
    }

    private long[] seedFromAnnot(AnnotatedElement element, long randomSeed) {
        Seed seed = element.getAnnotation(Seed.class);
        String seedChain = seed.value();
        if (seedChain.equals("random")) {
            return new long[]{randomSeed};
        }
        return SeedUtils.parseSeedChain(seedChain);
    }

    public TraceFormatting getTraceFormatting() {
        return this.traces;
    }

    public static String seedFromThrowable(Throwable t) {
        StringBuilder b = new StringBuilder();
        while (t != null) {
            for (StackTraceElement s : t.getStackTrace()) {
                if (!s.getClassName().startsWith(AUGMENTED_SEED_PACKAGE)) continue;
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append(s.getFileName());
            }
            t = t.getCause();
        }
        if (b.length() == 0) {
            return null;
        }
        return b.toString();
    }

    public static String methodName(Description description) {
        return description.getMethodName().replaceAll("\\s?\\{.+\\}", "");
    }

    static void checkZombies() throws AssumptionViolatedException {
        if (zombieMarker.get()) {
            throw new AssumptionViolatedException("Leaked background threads present (zombies).");
        }
    }

    static class QueueUncaughtExceptionsHandler
    implements Thread.UncaughtExceptionHandler {
        private final ArrayList<UncaughtException> uncaughtExceptions = new ArrayList();
        private boolean reporting = true;

        QueueUncaughtExceptionsHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread t, Throwable e) {
            QueueUncaughtExceptionsHandler queueUncaughtExceptionsHandler = this;
            synchronized (queueUncaughtExceptionsHandler) {
                if (!this.reporting) {
                    return;
                }
                this.uncaughtExceptions.add(new UncaughtException(t, e));
            }
            Logger.getLogger(RunnerThreadGroup.class.getSimpleName()).log(Level.WARNING, "Uncaught exception in thread: " + t, e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopReporting() {
            QueueUncaughtExceptionsHandler queueUncaughtExceptionsHandler = this;
            synchronized (queueUncaughtExceptionsHandler) {
                this.reporting = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resumeReporting() {
            QueueUncaughtExceptionsHandler queueUncaughtExceptionsHandler = this;
            synchronized (queueUncaughtExceptionsHandler) {
                this.reporting = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<UncaughtException> getUncaughtAndClear() {
            QueueUncaughtExceptionsHandler queueUncaughtExceptionsHandler = this;
            synchronized (queueUncaughtExceptionsHandler) {
                ArrayList<UncaughtException> copy = new ArrayList<UncaughtException>(this.uncaughtExceptions);
                this.uncaughtExceptions.clear();
                return copy;
            }
        }
    }

    static class UncaughtException {
        final Thread thread;
        final String threadName;
        final Throwable error;

        UncaughtException(Thread t, Throwable error) {
            this.threadName = Threads.threadName(t);
            this.thread = t;
            this.error = error;
        }
    }

    private static enum RunnerContainer {
        ECLIPSE,
        IDEA,
        UNKNOWN;

    }

    static class TestCandidate {
        public final long seed;
        public final Description description;
        public final Method method;
        public final InstanceProvider instanceProvider;

        public TestCandidate(Method method, long seed, Description description, InstanceProvider provider) {
            this.seed = seed;
            this.description = description;
            this.method = method;
            this.instanceProvider = provider;
        }
    }
}

