/*
 * Decompiled with CFR 0.152.
 */
package blade.servlet;

import blade.route.HttpMethod;
import blade.servlet.FileItem;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class ServletFileUpload {
    private static int BUF_SIZE = 0x100000;
    private HttpServletRequest request;
    private static final String MULTIPART = "multipart/";
    private Map<String, List<FileItem>> allFileItems;
    private ServletInputStream in;
    private byte[] buf;
    private String line;

    private ServletFileUpload(HttpServletRequest request) {
        this.request = request;
    }

    public boolean isMultipartContent(HttpServletRequest request) {
        if (!HttpMethod.POST.toString().equalsIgnoreCase(request.getMethod())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase(Locale.ENGLISH).startsWith(MULTIPART);
    }

    public String param(String name) {
        FileItem part = this.fileItem(name);
        return part != null && !part.isFile() ? part.getString() : null;
    }

    public String[] params(String name) {
        String[] params = null;
        FileItem[] parts = this.fileItems(name);
        if (parts != null) {
            params = new String[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                FileItem part = parts[i];
                params[i] = part.isFile() ? part.getString() : null;
            }
        }
        return params;
    }

    public FileItem fileItem(String name) {
        FileItem[] parts = this.fileItems(name);
        return parts == null ? null : parts[0];
    }

    public FileItem[] fileItems(String name) {
        try {
            if (this.allFileItems == null) {
                this.parseMultiFileItem();
            }
            if (this.allFileItems == null) {
                return null;
            }
            List<FileItem> list = this.allFileItems.get(name);
            if (list == null || list.size() == 0) {
                return null;
            }
            return list.toArray(new FileItem[list.size()]);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void setBufferSize(int buffer) {
        BUF_SIZE = buffer;
    }

    public void parseMultiFileItem() throws IOException {
        this.in = this.request.getInputStream();
        this.buf = new byte[BUF_SIZE];
        String contentType = this.request.getContentType();
        int pos = contentType.indexOf("boundary=");
        String boundary = contentType.substring(pos + 9);
        FileItem fileItem = null;
        int len = -1;
        while ((len = this.readLine()) != -1) {
            if (this.line.endsWith(boundary)) {
                this.putFileItem(fileItem);
                this.readLine();
                fileItem = this.checkFileItem(this.line);
                if (fileItem.isFile()) {
                    this.readLine();
                    String type = this.line.substring("Content-Type: ".length());
                    fileItem.setContentType(type);
                }
                this.readLine();
                continue;
            }
            if (this.line.indexOf(boundary) > -1) {
                this.putFileItem(fileItem);
                break;
            }
            fileItem.write(this.buf, 0, len);
            fileItem.setInputStream((InputStream)this.in);
        }
    }

    private FileItem checkFileItem(String disposition) {
        String regexFile = "^Content-Disposition: form-data; name=\"(.+)\"; filename=\"(.+)\"$";
        String regexComm = "^Content-Disposition: form-data; name=\"(.+)\"$";
        FileItem fileItem = new FileItem();
        Matcher m = Pattern.compile(regexFile).matcher(disposition);
        if (m.find()) {
            fileItem.setFile(true);
            fileItem.setName(m.group(1));
            fileItem.setFileName(m.group(2));
            return fileItem;
        }
        m = Pattern.compile(regexComm).matcher(disposition);
        if (m.find()) {
            fileItem.setFile(false);
            fileItem.setName(m.group(1));
            return fileItem;
        }
        return null;
    }

    private int readLine() throws IOException {
        int len = this.in.readLine(this.buf, 0, this.buf.length);
        this.line = new String(this.buf, 0, len).trim();
        return len;
    }

    private void putFileItem(FileItem fileItem) {
        List<FileItem> list;
        if (fileItem == null) {
            return;
        }
        if (this.allFileItems == null) {
            this.allFileItems = new HashMap<String, List<FileItem>>();
        }
        if ((list = this.allFileItems.get(fileItem.getName())) == null) {
            list = new ArrayList<FileItem>();
            this.allFileItems.put(fileItem.getName(), list);
        }
        list.add(fileItem);
    }

    public static ServletFileUpload parseRequest(HttpServletRequest servletRequest) {
        return new ServletFileUpload(servletRequest);
    }
}

