/*
 * Decompiled with CFR 0.152.
 */
package blade.servlet;

import blade.kit.log.Logger;
import blade.render.ModelAndView;
import blade.render.Render;
import blade.render.RenderFactory;
import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;

public class Response {
    private static final Logger LOGGER = Logger.getLogger(Response.class);
    private HttpServletResponse response;
    private Render render = RenderFactory.getRender();
    private String body;

    protected Response() {
    }

    public Response(HttpServletResponse response) {
        this.response = response;
    }

    public void status(int statusCode) {
        this.response.setStatus(statusCode);
    }

    public void contentType(String contentType) {
        this.response.setContentType(contentType);
    }

    public void body(String body) {
        this.body = body;
    }

    public String body() {
        return this.body;
    }

    public HttpServletResponse servletResponse() {
        return this.response;
    }

    public void redirect(String location) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Redirecting ({} {} to {}", new Object[]{"Found", 302, location});
        }
        try {
            this.response.sendRedirect(location);
        }
        catch (IOException ioException) {
            LOGGER.warn((Object)"Redirect failure", (Throwable)ioException);
        }
    }

    public void redirect(String location, int statusCode) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Redirecting ({} to {}", new Object[]{statusCode, location});
        }
        this.response.setStatus(statusCode);
        this.response.setHeader("Location", location);
        this.response.setHeader("Connection", "close");
        try {
            this.response.sendError(statusCode);
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Exception when trying to redirect permanently", (Throwable)e);
        }
    }

    public void header(String header, String value) {
        this.response.addHeader(header, value);
    }

    public void cookie(String name, String value) {
        this.cookie(name, value, -1, false);
    }

    public void cookie(String name, String value, int maxAge) {
        this.cookie(name, value, maxAge, false);
    }

    public void cookie(String name, String value, int maxAge, boolean secured) {
        this.cookie("", name, value, maxAge, secured);
    }

    public void cookie(String path, String name, String value, int maxAge, boolean secured) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(path);
        cookie.setMaxAge(maxAge);
        cookie.setSecure(secured);
        this.response.addCookie(cookie);
    }

    public void removeCookie(String name) {
        Cookie cookie = new Cookie(name, "");
        cookie.setMaxAge(0);
        this.response.addCookie(cookie);
    }

    public void render(String view) {
        this.render.render(view);
    }

    public void render(ModelAndView modelAndView) {
        this.render.render(modelAndView);
    }

    public void text(String text) {
        this.render.text(text);
    }

    public void json(String json) {
        this.render.json(json);
    }

    public void xml(String xml) {
        this.render.xml(xml);
    }

    public void javascript(String javascript) {
        this.render.javascript(javascript);
    }

    public void html(String html) {
        this.render.html(html);
    }

    public void render404(String viewName) {
        this.render.render404(this.response, viewName);
    }

    public void render500(String bodyContent) {
        this.render.render500(bodyContent);
    }
}

