/*
 * Decompiled with CFR 0.152.
 */
package blade.servlet;

import blade.kit.IOKit;
import blade.kit.PathKit;
import blade.kit.StringKit;
import blade.kit.log.Logger;
import blade.route.RouteMatcher;
import blade.servlet.QueryParamsMap;
import blade.servlet.Session;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class Request {
    private static final Logger LOGGER = Logger.getLogger(Request.class);
    private static final String USER_AGENT = "user-agent";
    private Map<String, String> pathParams;
    private List<String> splat;
    private QueryParamsMap queryMap;
    private HttpServletRequest servletRequest;
    private Session session = null;
    private String body = null;
    private byte[] bodyAsBytes = null;
    private Set<String> headers = null;

    protected Request() {
    }

    public Request(RouteMatcher match, HttpServletRequest request) {
        this.servletRequest = request;
        this.initRequest(match);
    }

    public void initRequest(RouteMatcher match) {
        List<String> requestList = PathKit.convertRouteToList(match.getRequestURI());
        List<String> pathList = PathKit.convertRouteToList(match.getPath());
        this.pathParams = Request.getPathParams(requestList, pathList);
        this.splat = Request.getSplat(requestList, pathList);
    }

    public Map<String, String> pathParams() {
        return Collections.unmodifiableMap(this.pathParams);
    }

    public String pathParam(String param) {
        if (param == null) {
            return null;
        }
        if (param.startsWith(":")) {
            return this.pathParams.get(param.toLowerCase());
        }
        return this.pathParams.get(":" + param.toLowerCase());
    }

    public Integer pathParamToInt(String param) {
        String value = this.pathParam(param);
        if (null != value) {
            return Integer.valueOf(value);
        }
        return null;
    }

    public String[] splat() {
        return this.splat.toArray(new String[this.splat.size()]);
    }

    public String requestMethod() {
        return this.servletRequest.getMethod();
    }

    public String scheme() {
        return this.servletRequest.getScheme();
    }

    public String host() {
        return this.servletRequest.getHeader("host");
    }

    public String userAgent() {
        return this.servletRequest.getHeader(USER_AGENT);
    }

    public int port() {
        return this.servletRequest.getServerPort();
    }

    public String pathInfo() {
        return this.servletRequest.getPathInfo();
    }

    public String servletPath() {
        return this.servletRequest.getServletPath();
    }

    public String contextPath() {
        return this.servletRequest.getContextPath();
    }

    public String url() {
        return this.servletRequest.getRequestURL().toString();
    }

    public String contentType() {
        return this.servletRequest.getContentType();
    }

    public String ip() {
        return this.servletRequest.getRemoteAddr();
    }

    public String body() {
        if (this.body == null) {
            this.readBody();
        }
        return this.body;
    }

    public byte[] bodyAsBytes() {
        if (this.bodyAsBytes == null) {
            this.readBody();
        }
        return this.bodyAsBytes;
    }

    private void readBody() {
        try {
            this.bodyAsBytes = IOKit.toByteArray((InputStream)this.servletRequest.getInputStream());
            this.body = new String(this.bodyAsBytes);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Exception when reading body", (Throwable)e);
        }
    }

    public int contentLength() {
        return this.servletRequest.getContentLength();
    }

    public String query(String queryParam) {
        return this.servletRequest.getParameter(queryParam);
    }

    public String[] querys(String queryParam) {
        return this.servletRequest.getParameterValues(queryParam);
    }

    public Integer queryToInt(String queryParam) {
        String value = this.query(queryParam);
        if (StringKit.isNotEmpty((String)value)) {
            return Integer.valueOf(value);
        }
        return null;
    }

    public Long queryToLong(String queryParam) {
        String value = this.query(queryParam);
        if (StringKit.isNotEmpty((String)value)) {
            return Long.valueOf(value);
        }
        return null;
    }

    public Boolean queryToBoolean(String queryParam) {
        String value = this.query(queryParam);
        if (StringKit.isNotEmpty((String)value)) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    public Double queryToDouble(String queryParam) {
        String value = this.query(queryParam);
        if (StringKit.isNotEmpty((String)value)) {
            return Double.valueOf(value);
        }
        return null;
    }

    public Float queryToFloat(String queryParam) {
        String value = this.query(queryParam);
        if (StringKit.isNotEmpty((String)value)) {
            return Float.valueOf(value);
        }
        return null;
    }

    public String header(String header) {
        return this.servletRequest.getHeader(header);
    }

    public Set<String> querys() {
        return this.servletRequest.getParameterMap().keySet();
    }

    public Set<String> headers() {
        if (this.headers == null) {
            this.headers = new TreeSet<String>();
            Enumeration enumeration = this.servletRequest.getHeaderNames();
            while (enumeration.hasMoreElements()) {
                this.headers.add((String)enumeration.nextElement());
            }
        }
        return this.headers;
    }

    public String queryString() {
        return this.servletRequest.getQueryString();
    }

    public void attribute(String attribute, Object value) {
        this.servletRequest.setAttribute(attribute, value);
    }

    public Object attribute(String attribute) {
        return this.servletRequest.getAttribute(attribute);
    }

    public Set<String> attributes() {
        HashSet<String> attrList = new HashSet<String>();
        Enumeration attributes = this.servletRequest.getAttributeNames();
        while (attributes.hasMoreElements()) {
            attrList.add((String)attributes.nextElement());
        }
        return attrList;
    }

    public HttpServletRequest servletRequest() {
        return this.servletRequest;
    }

    public QueryParamsMap queryMap() {
        this.initQueryMap();
        return this.queryMap;
    }

    public QueryParamsMap queryMap(String key) {
        return this.queryMap().get(key);
    }

    private void initQueryMap() {
        if (this.queryMap == null) {
            this.queryMap = new QueryParamsMap(this.servletRequest());
        }
    }

    public Session session() {
        if (this.session == null) {
            this.session = new Session(this.servletRequest.getSession());
        }
        return this.session;
    }

    public Session session(boolean create) {
        HttpSession httpSession;
        if (this.session == null && (httpSession = this.servletRequest.getSession(create)) != null) {
            this.session = new Session(httpSession);
        }
        return this.session;
    }

    public Map<String, String> cookies() {
        HashMap<String, String> result = new HashMap<String, String>();
        Cookie[] cookies = this.servletRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                result.put(cookie.getName(), cookie.getValue());
            }
        }
        return result;
    }

    public String cookie(String name) {
        Cookie[] cookies = this.servletRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public String uri() {
        return this.servletRequest.getRequestURI();
    }

    public String protocol() {
        return this.servletRequest.getProtocol();
    }

    private static Map<String, String> getPathParams(List<String> request, List<String> matched) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < request.size() && i < matched.size(); ++i) {
            String matchedPart = matched.get(i);
            if (!PathKit.isParam(matchedPart)) continue;
            LOGGER.debug((Object)("matchedPart: " + matchedPart + " = " + request.get(i)));
            params.put(matchedPart.toLowerCase(), request.get(i));
        }
        return Collections.unmodifiableMap(params);
    }

    private static List<String> getSplat(List<String> request, List<String> matched) {
        int nbrOfMatchedParts;
        int nbrOfRequestParts = request.size();
        boolean sameLength = nbrOfRequestParts == (nbrOfMatchedParts = matched.size());
        ArrayList<String> splat = new ArrayList<String>();
        for (int i = 0; i < nbrOfRequestParts && i < nbrOfMatchedParts; ++i) {
            String matchedPart = matched.get(i);
            if (!PathKit.isSplat(matchedPart)) continue;
            StringBuilder splatParam = new StringBuilder(request.get(i));
            if (!sameLength && i == nbrOfMatchedParts - 1) {
                for (int j = i + 1; j < nbrOfRequestParts; ++j) {
                    splatParam.append("/");
                    splatParam.append(request.get(j));
                }
            }
            splat.add(splatParam.toString());
        }
        return Collections.unmodifiableList(splat);
    }
}

