/*
 * Decompiled with CFR 0.152.
 */
package blade.servlet;

import blade.kit.io.FastByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class FileItem {
    private String name;
    private boolean isFile;
    private String fileName;
    private String contentType;
    private InputStream inputStream;
    public static final String FORM_DATA = "form-data";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private FastByteArrayOutputStream outputStream;

    public void write(byte[] buf, int off, int len) {
        if (this.outputStream == null) {
            this.outputStream = new FastByteArrayOutputStream();
        }
        this.outputStream.write(buf, off, len);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public void setFile(boolean isFile) {
        this.isFile = isFile;
    }

    public byte[] getFileContent() {
        byte[] buf = this.outputStream.toByteArray();
        int dirtyCount = 2;
        if (13 != buf[buf.length - 2]) {
            dirtyCount = 1;
        }
        return Arrays.copyOfRange(buf, 0, buf.length - dirtyCount);
    }

    public String getString(String encoding) {
        try {
            return this.outputStream == null ? null : new String(this.getFileContent(), encoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getString() {
        return this.outputStream == null ? null : new String(this.getFileContent());
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }
}

