/*
 * Decompiled with CFR 0.152.
 */
package blade.server;

import blade.Blade;
import blade.BladeFilter;
import blade.kit.log.Logger;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.webapp.WebAppContext;

public final class BladeServer {
    private static String DEFAULT_APP_PATH = BladeServer.class.getClassLoader().getResource("").getPath();
    private static final Logger LOGGER = Logger.getLogger(BladeServer.class);

    private BladeServer() {
    }

    public static void setDefaultAppPath(String defaultPath) {
        DEFAULT_APP_PATH = defaultPath;
    }

    public static Server createServerInSource(Integer port, String host, String contextPath) {
        Server server = new Server();
        server.setStopAtShutdown(true);
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(port.intValue());
        connector.setHost(host);
        connector.setReuseAddress(false);
        connector.setName("blade-jetty-server");
        server.setConnectors(new Connector[]{connector});
        WebAppContext webContext = new WebAppContext(DEFAULT_APP_PATH, contextPath);
        webContext.addFilter(BladeFilter.class, "/*", EnumSet.of(DispatcherType.INCLUDE, DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ASYNC));
        webContext.setResourceBase(DEFAULT_APP_PATH);
        webContext.setClassLoader(Thread.currentThread().getContextClassLoader());
        server.setHandler((Handler)webContext);
        return server;
    }

    public static void run(Integer port, String host, String contextPath) {
        try {
            if (null == port) {
                port = 9000;
            }
            if (null == host) {
                host = "0.0.0.0";
            }
            if (null == contextPath) {
                contextPath = "/";
            }
            Server server = BladeServer.createServerInSource(port, host, contextPath);
            Blade.runJetty = true;
            server.stop();
            server.start();
            LOGGER.info((Object)("Blade Server Run In : http://" + host + ":" + port + contextPath));
            server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    static {
        try {
            File rootDir = new File("");
            String courseFile = rootDir.getCanonicalPath();
            File webapp = new File(courseFile + File.separator + "src/main/webapp");
            if (webapp.exists()) {
                DEFAULT_APP_PATH = "src/main/webapp";
            } else {
                webapp = new File(courseFile + File.separator + "WebContent/");
                if (webapp.exists()) {
                    DEFAULT_APP_PATH = "WebContent";
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

