/*
 * Decompiled with CFR 0.152.
 */
package blade.route;

import blade.Blade;
import blade.annotation.After;
import blade.annotation.Before;
import blade.annotation.Interceptor;
import blade.annotation.Path;
import blade.annotation.Route;
import blade.ioc.Container;
import blade.ioc.DefaultContainer;
import blade.kit.log.Logger;
import blade.kit.resource.ClassPathClassReader;
import blade.kit.resource.ClassReader;
import blade.route.DefaultRouteMatcher;
import blade.route.HttpMethod;
import java.lang.reflect.Method;
import java.util.Set;

public final class RouteMatcherBuilder {
    private static final Logger LOGGER = Logger.getLogger(RouteMatcherBuilder.class);
    private static DefaultRouteMatcher routeMatcher = null;
    private static final ClassReader classReader = new ClassPathClassReader();
    private static final Container container = DefaultContainer.single();

    private RouteMatcherBuilder() {
    }

    public static synchronized DefaultRouteMatcher building() {
        String[] basePackages;
        if (routeMatcher != null) {
            routeMatcher.clearRoutes();
            routeMatcher = null;
        }
        routeMatcher = new DefaultRouteMatcher();
        if (Blade.debug()) {
            LOGGER.debug((Object)"creates RouteMatcher");
        }
        if (null != (basePackages = Blade.defaultRoutes()) && basePackages.length > 0) {
            String basePackage = basePackages[0];
            String suffix = basePackage.endsWith(".*") ? ".*" : "";
            basePackage = basePackage.endsWith(".*") ? basePackage.substring(0, basePackage.length() - 2) : basePackage;
            String routePackage = basePackage + "." + Blade.PACKAGE_ROUTE + suffix;
            String interceptorPackage = basePackage + "." + Blade.PACKAGE_INTERCEPTOR + suffix;
            RouteMatcherBuilder.buildRoute(routePackage);
            RouteMatcherBuilder.buildInterceptor(interceptorPackage);
        } else {
            String[] interceptorPackages;
            String[] routePackages = Blade.routes();
            if (null != routePackages && routePackages.length > 0) {
                RouteMatcherBuilder.buildRoute(routePackages);
            }
            if (null != (interceptorPackages = Blade.interceptor()) && interceptorPackages.length > 0) {
                RouteMatcherBuilder.buildInterceptor(interceptorPackages);
            }
        }
        return routeMatcher;
    }

    private static void buildInterceptor(String ... interceptorPackages) {
        for (String packageName : interceptorPackages) {
            Set classes;
            boolean recursive = false;
            if (packageName.endsWith(".*")) {
                packageName = packageName.substring(0, packageName.length() - 2);
                recursive = true;
            }
            if (null == (classes = classReader.getClassByAnnotation(packageName, Interceptor.class, recursive)) || classes.size() <= 0) continue;
            for (Class interceptorClazz : classes) {
                RouteMatcherBuilder.parseInterceptor(interceptorClazz);
            }
        }
    }

    private static void buildRoute(String ... routePackages) {
        for (String packageName : routePackages) {
            Set classes;
            boolean recursive = false;
            if (packageName.endsWith(".*")) {
                packageName = packageName.substring(0, packageName.length() - 2);
                recursive = true;
            }
            if (null == (classes = classReader.getClassByAnnotation(packageName, Path.class, recursive)) || classes.size() <= 0) continue;
            for (Class pathClazz : classes) {
                RouteMatcherBuilder.parseRouter(pathClazz);
            }
        }
    }

    private static void parseInterceptor(Class<?> interceptor) {
        Method[] methods = interceptor.getMethods();
        if (null == methods || methods.length == 0) {
            return;
        }
        container.registBean(interceptor);
        for (Method method : methods) {
            String acceptType;
            String path;
            Before before = method.getAnnotation(Before.class);
            After after = method.getAnnotation(After.class);
            if (null != before) {
                path = before.value().startsWith("/") ? before.value() : "/" + before.value();
                path = path.length() > 1 && path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
                acceptType = before.acceptType();
                RouteMatcherBuilder.buildInterceptor(interceptor, method, path, HttpMethod.BEFORE, acceptType);
            }
            if (null == after) continue;
            path = after.value().startsWith("/") ? after.value() : "/" + after.value();
            path = path.length() > 1 && path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
            acceptType = after.acceptType();
            RouteMatcherBuilder.buildInterceptor(interceptor, method, path, HttpMethod.AFTER, acceptType);
        }
    }

    private static void parseRouter(Class<?> router) {
        Method[] methods = router.getMethods();
        if (null == methods || methods.length == 0) {
            return;
        }
        String nameSpace = router.getAnnotation(Path.class).value();
        container.registBean(router);
        for (Method method : methods) {
            Route mapping = method.getAnnotation(Route.class);
            if (null == mapping) continue;
            String path = mapping.value().startsWith("/") ? mapping.value() : "/" + mapping.value();
            path = nameSpace + path;
            path = path.replaceAll("[/]+", "/");
            path = path.length() > 1 && path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
            HttpMethod methodType = mapping.method();
            String acceptType = mapping.acceptType();
            RouteMatcherBuilder.buildRoute(router, method, path, methodType, acceptType);
        }
    }

    private static void buildRoute(Class<?> target, Method execMethod, String path, HttpMethod method, String acceptType) {
        routeMatcher.addRoute(target, execMethod, path, method, acceptType);
    }

    private static void buildInterceptor(Class<?> target, Method execMethod, String path, HttpMethod method, String acceptType) {
        routeMatcher.addInterceptor(target, execMethod, path, method, acceptType);
    }
}

