/*
 * Decompiled with CFR 0.152.
 */
package blade.route;

import blade.kit.PathKit;
import blade.route.HttpMethod;
import java.lang.reflect.Method;
import java.util.List;

public class RouteMatcher {
    Class<?> target;
    Method execMethod;
    HttpMethod httpMethod;
    String path;
    String requestURI;
    String acceptType;

    public RouteMatcher() {
    }

    public RouteMatcher(Class<?> target, Method execMethod, HttpMethod httpMethod, String path, String requestUri, String acceptType) {
        this.target = target;
        this.execMethod = execMethod;
        this.httpMethod = httpMethod;
        this.path = path;
        this.requestURI = requestUri;
        this.acceptType = acceptType;
    }

    public String getAcceptType() {
        return this.acceptType;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public Method getExecMethod() {
        return this.execMethod;
    }

    public String getPath() {
        return this.path;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public Class<?> getTarget() {
        return this.target;
    }

    boolean matches(HttpMethod httpMethod, String path) {
        if ((httpMethod == HttpMethod.BEFORE || httpMethod == HttpMethod.AFTER) && this.httpMethod == httpMethod && this.path.equals("/*")) {
            return true;
        }
        boolean match = false;
        if (this.httpMethod == HttpMethod.ALL || this.httpMethod == httpMethod) {
            match = this.matchPath(path);
        }
        return match;
    }

    private boolean matchPath(String uri) {
        int uriSize;
        if (!this.path.endsWith("*") && (uri.endsWith("/") && !this.path.endsWith("/") || this.path.endsWith("/") && !uri.endsWith("/"))) {
            return false;
        }
        if (this.path.equals(uri)) {
            return true;
        }
        List<String> thisPathList = PathKit.convertRouteToList(this.path);
        List<String> uriList = PathKit.convertRouteToList(uri);
        int thisPathSize = thisPathList.size();
        if (thisPathSize == (uriSize = uriList.size())) {
            for (int i = 0; i < thisPathSize; ++i) {
                String thisPathPart = thisPathList.get(i);
                String pathPart = uriList.get(i);
                if (i == thisPathSize - 1 && thisPathPart.equals("*") && this.path.endsWith("*")) {
                    return true;
                }
                if (thisPathPart.startsWith(":") || thisPathPart.equals(pathPart) || thisPathPart.equals("*")) continue;
                return false;
            }
            return true;
        }
        if (this.path.endsWith("*")) {
            if (uriSize == thisPathSize - 1 && this.path.endsWith("/")) {
                uriList.add("");
                uriList.add("");
                uriSize += 2;
            }
            if (thisPathSize < uriSize) {
                for (int i = 0; i < thisPathSize; ++i) {
                    String thisPathPart = thisPathList.get(i);
                    String pathPart = uriList.get(i);
                    if (thisPathPart.equals("*") && i == thisPathSize - 1 && this.path.endsWith("*")) {
                        return true;
                    }
                    if (thisPathPart.startsWith(":") || thisPathPart.equals(pathPart) || thisPathPart.equals("*")) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RouteMatcher) {
            RouteMatcher r = (RouteMatcher)obj;
            return this.httpMethod == r.httpMethod && this.execMethod.getName().equals(r.execMethod.getName()) && this.path.equals(r.path) && this.acceptType.equals(r.acceptType);
        }
        return false;
    }

    public String toString() {
        return this.httpMethod.name() + "------" + this.path;
    }
}

