/*
 * Decompiled with CFR 0.152.
 */
package blade.route;

import blade.Blade;
import blade.kit.MimeParse;
import blade.kit.StringKit;
import blade.kit.log.Logger;
import blade.route.HttpMethod;
import blade.route.RouteMatcher;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultRouteMatcher {
    private static final Logger LOGGER = Logger.getLogger(DefaultRouteMatcher.class);
    private List<RouteMatcher> routes = new ArrayList<RouteMatcher>();
    private List<RouteMatcher> interceptors = new ArrayList<RouteMatcher>();

    public RouteMatcher findRouteMatcher(HttpMethod httpMethod, String uri, String acceptType) {
        uri = uri.length() > 1 && uri.endsWith("/") ? uri.substring(0, uri.length() - 1) : uri;
        List<RouteMatcher> routeEntries = this.findRouteMatcher(httpMethod, uri);
        RouteMatcher entry = this.findTargetWithGivenAcceptType(routeEntries, acceptType);
        return entry != null ? new RouteMatcher(entry.target, entry.execMethod, entry.httpMethod, entry.path, uri, acceptType) : null;
    }

    public List<RouteMatcher> findInterceptor(HttpMethod httpMethod, String uri, String acceptType) {
        if (uri.length() > 1) {
            uri = uri.endsWith("/") ? uri.substring(0, uri.length() - 1) : uri;
        }
        ArrayList<RouteMatcher> matchSet = new ArrayList<RouteMatcher>();
        List<RouteMatcher> routeEntries = this.findInterceptor(httpMethod, uri);
        for (RouteMatcher routeEntry : routeEntries) {
            if (acceptType != null) {
                String bestMatch = MimeParse.bestMatch(Arrays.asList(routeEntry.acceptType), (String)acceptType);
                if (!this.routeWithGivenAcceptType(bestMatch)) continue;
                matchSet.add(routeEntry);
                continue;
            }
            matchSet.add(routeEntry);
        }
        return matchSet;
    }

    public void clearRoutes() {
        this.routes.clear();
    }

    public boolean removeRoute(String path, String httpMethod) {
        if (StringKit.isEmpty((String)path)) {
            throw new IllegalArgumentException("path cannot be null or blank");
        }
        if (StringKit.isEmpty((String)httpMethod)) {
            throw new IllegalArgumentException("httpMethod cannot be null or blank");
        }
        HttpMethod method = HttpMethod.valueOf(httpMethod);
        return this.removeRoute(method, path);
    }

    public boolean removeRoute(String path) {
        if (StringKit.isEmpty((String)path)) {
            throw new IllegalArgumentException("path cannot be null or blank");
        }
        return this.removeRoute((HttpMethod)null, path);
    }

    public void addRoute(Class<?> target, Method execMethod, String url, HttpMethod method, String acceptType) {
        RouteMatcher entry = new RouteMatcher();
        entry.target = target;
        entry.execMethod = execMethod;
        entry.httpMethod = method;
        entry.path = url;
        entry.requestURI = url;
        entry.acceptType = acceptType;
        if (Blade.debug()) {
            LOGGER.debug((Object)("Add Route\uff1a" + entry));
        }
        this.routes.add(entry);
    }

    public void addInterceptor(Class<?> target, Method execMethod, String url, HttpMethod method, String acceptType) {
        RouteMatcher entry = new RouteMatcher();
        entry.target = target;
        entry.execMethod = execMethod;
        entry.httpMethod = method;
        entry.path = url;
        entry.requestURI = url;
        entry.acceptType = acceptType;
        if (Blade.debug()) {
            LOGGER.debug((Object)("Add Interceptor\uff1a" + entry));
        }
        this.interceptors.add(entry);
    }

    private Map<String, RouteMatcher> getAcceptedMimeTypes(List<RouteMatcher> routes) {
        HashMap<String, RouteMatcher> acceptedTypes = new HashMap<String, RouteMatcher>();
        for (RouteMatcher routeEntry : routes) {
            if (acceptedTypes.containsKey(routeEntry.acceptType)) continue;
            acceptedTypes.put(routeEntry.acceptType, routeEntry);
        }
        return acceptedTypes;
    }

    private boolean routeWithGivenAcceptType(String bestMatch) {
        return !"".equals(bestMatch);
    }

    private List<RouteMatcher> findRouteMatcher(HttpMethod httpMethod, String path) {
        path = path.length() > 1 && path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        ArrayList<RouteMatcher> matchSet = new ArrayList<RouteMatcher>();
        for (RouteMatcher entry : this.routes) {
            if (!entry.matches(httpMethod, path)) continue;
            matchSet.add(entry);
        }
        return matchSet;
    }

    private List<RouteMatcher> findInterceptor(HttpMethod httpMethod, String path) {
        ArrayList<RouteMatcher> matchSet = new ArrayList<RouteMatcher>();
        for (RouteMatcher entry : this.interceptors) {
            if (!entry.matches(httpMethod, path)) continue;
            matchSet.add(entry);
        }
        return matchSet;
    }

    private RouteMatcher findTargetWithGivenAcceptType(List<RouteMatcher> routeMatches, String acceptType) {
        if (acceptType != null && routeMatches.size() > 0) {
            Map<String, RouteMatcher> acceptedMimeTypes = this.getAcceptedMimeTypes(routeMatches);
            String bestMatch = MimeParse.bestMatch(acceptedMimeTypes.keySet(), (String)acceptType);
            if (this.routeWithGivenAcceptType(bestMatch)) {
                return acceptedMimeTypes.get(bestMatch);
            }
            return null;
        }
        if (routeMatches.size() > 0) {
            return routeMatches.get(0);
        }
        return null;
    }

    private boolean removeRoute(HttpMethod httpMethod, String path) {
        ArrayList<RouteMatcher> forRemoval = new ArrayList<RouteMatcher>();
        for (RouteMatcher routeEntry : this.routes) {
            HttpMethod httpMethodToMatch = httpMethod;
            if (httpMethod == null) {
                httpMethodToMatch = routeEntry.httpMethod;
            }
            if (!routeEntry.matches(httpMethodToMatch, path)) continue;
            if (Blade.debug()) {
                LOGGER.debug((Object)"Removing path {}", new Object[]{path, httpMethod == null ? "" : " with HTTP method " + (Object)((Object)httpMethod)});
            }
            forRemoval.add(routeEntry);
        }
        return this.routes.removeAll(forRemoval);
    }
}

