/*
 * Decompiled with CFR 0.152.
 */
package blade.render;

import blade.Blade;
import blade.BladeWebContext;
import blade.render.ModelAndView;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class Render {
    static final String VIEW_NOTFOUND = "<html><body><h2>404 %s</h2></body></html>";

    public void render404(String viewName) {
        this.render404(null, viewName);
    }

    public void render404(HttpServletResponse httpResponse, String viewName) {
        try {
            String view404 = Blade.view404();
            if (null != view404) {
                ModelAndView modelAndView = new ModelAndView(view404);
                modelAndView.add("viewName", viewName);
                this.render(modelAndView);
            } else {
                if (null == httpResponse) {
                    httpResponse = BladeWebContext.servletResponse();
                }
                httpResponse.setContentType("text/html; charset=utf-8");
                httpResponse.setStatus(404);
                ServletOutputStream outputStream = httpResponse.getOutputStream();
                outputStream.print(String.format(VIEW_NOTFOUND, viewName + " Not Found"));
                outputStream.flush();
                outputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void render500(String bodyContent) {
        try {
            String view500 = Blade.view500();
            if (null != view500) {
                ModelAndView modelAndView = new ModelAndView(view500);
                modelAndView.add("body", bodyContent);
                this.render(modelAndView);
            } else {
                HttpServletResponse httpResponse = BladeWebContext.servletResponse();
                httpResponse.setContentType("text/html; charset=utf-8");
                ServletOutputStream outputStream = httpResponse.getOutputStream();
                outputStream.print(bodyContent.toString());
                outputStream.flush();
                outputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void json(String json) {
        if (null != json) {
            HttpServletResponse response = BladeWebContext.servletResponse();
            HttpServletRequest request = BladeWebContext.servletRequest();
            response.setHeader("Cache-Control", "no-cache");
            String userAgent = request.getHeader("User-Agent");
            if (userAgent.contains("MSIE")) {
                response.setContentType("text/html;charset=utf-8");
            } else {
                response.setContentType("application/json;charset=utf-8");
            }
            try {
                request.setCharacterEncoding("utf-8");
                PrintWriter out = response.getWriter();
                out.print(json.toString());
                out.flush();
                out.close();
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void text(String text) {
        if (null != text) {
            HttpServletResponse response = BladeWebContext.servletResponse();
            HttpServletRequest request = BladeWebContext.servletRequest();
            response.setHeader("Cache-Control", "no-cache");
            response.setContentType("text/plain;charset=utf-8");
            try {
                request.setCharacterEncoding("utf-8");
                PrintWriter out = response.getWriter();
                out.print(text);
                out.flush();
                out.close();
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void xml(String xml) {
        if (null != xml) {
            HttpServletResponse response = BladeWebContext.servletResponse();
            HttpServletRequest request = BladeWebContext.servletRequest();
            response.setHeader("Cache-Control", "no-cache");
            response.setContentType("text/xml;charset=utf-8");
            try {
                request.setCharacterEncoding("utf-8");
                PrintWriter out = response.getWriter();
                out.print(xml);
                out.flush();
                out.close();
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void html(String html) {
        if (null != html) {
            HttpServletResponse response = BladeWebContext.servletResponse();
            HttpServletRequest request = BladeWebContext.servletRequest();
            response.setHeader("Cache-Control", "no-cache");
            response.setContentType("text/html;charset=utf-8");
            try {
                request.setCharacterEncoding("utf-8");
                PrintWriter out = response.getWriter();
                out.print(html);
                out.flush();
                out.close();
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void javascript(String javascript) {
        if (null != javascript) {
            HttpServletResponse response = BladeWebContext.servletResponse();
            HttpServletRequest request = BladeWebContext.servletRequest();
            response.setHeader("Cache-Control", "no-cache");
            response.setContentType("text/javascript;charset=utf-8");
            try {
                request.setCharacterEncoding("utf-8");
                PrintWriter out = response.getWriter();
                out.print(javascript);
                out.flush();
                out.close();
            }
            catch (UnsupportedEncodingException e1) {
                e1.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    String disposeView(String view) {
        if (null != view) {
            view = Blade.viewPath() + view;
            if (!(view = view.replaceAll("[/]+", "/")).endsWith(Blade.viewExt())) {
                view = view + Blade.viewExt();
            }
        }
        return view;
    }

    public abstract Object render(String var1);

    public abstract Object render(ModelAndView var1);
}

