/*
 * Decompiled with CFR 0.152.
 */
package blade.render;

import blade.Blade;
import blade.BladeWebContext;
import blade.render.ModelAndView;
import blade.render.Render;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class JspRender
extends Render {
    private JspRender() {
    }

    @Override
    public Object render(String view) {
        try {
            HttpServletRequest servletRequest = BladeWebContext.servletRequest();
            HttpServletResponse servletResponse = BladeWebContext.servletResponse();
            servletRequest.setCharacterEncoding(Blade.encoding());
            servletResponse.setCharacterEncoding(Blade.encoding());
            String realPath = this.disposeView(view);
            servletRequest.getRequestDispatcher(realPath).forward((ServletRequest)servletRequest, (ServletResponse)servletResponse);
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Object render(ModelAndView modelAndView) {
        try {
            HttpServletRequest servletRequest = BladeWebContext.servletRequest();
            HttpServletResponse servletResponse = BladeWebContext.servletResponse();
            String realPath = this.disposeView(modelAndView.getView());
            Map<String, Object> model = modelAndView.getModel();
            if (null != model && !model.isEmpty()) {
                Set<String> keys = model.keySet();
                for (String key : keys) {
                    servletRequest.setAttribute(key, model.get(key));
                }
            }
            servletRequest.getRequestDispatcher(realPath).forward((ServletRequest)servletRequest, (ServletResponse)servletResponse);
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static JspRender single() {
        return JspRenderHolder.single;
    }

    private static class JspRenderHolder {
        private static final JspRender single = new JspRender();

        private JspRenderHolder() {
        }
    }
}

