/*
 * Decompiled with CFR 0.152.
 */
package blade.ioc;

import blade.annotation.Component;
import blade.annotation.Inject;
import blade.annotation.Path;
import blade.ioc.Container;
import blade.ioc.Scope;
import blade.kit.CloneKit;
import blade.kit.CollectionKit;
import blade.kit.ReflectKit;
import blade.kit.log.Logger;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultContainer
implements Container {
    private static final Logger LOGGER = Logger.getLogger(DefaultContainer.class);
    private static final Map<String, Object> beansMap = CollectionKit.newConcurrentHashMap();
    private static final Map<Class<? extends Annotation>, List<Object>> annotationMap = CollectionKit.newConcurrentHashMap();

    private DefaultContainer() {
    }

    public static DefaultContainer single() {
        return DefaultContainerHoder.single;
    }

    @Override
    public Map<String, Object> getBeanMap() {
        return beansMap;
    }

    @Override
    public Object getBean(String name, Scope scope) {
        Object obj = beansMap.get(name);
        if (null != scope && scope == Scope.PROTOTYPE) {
            try {
                return CloneKit.deepClone((Object)obj);
            }
            catch (Exception e) {
                LOGGER.error((Object)("\u514b\u9686\u5bf9\u8c61\u5931\u8d25," + e.getMessage()));
            }
        }
        return obj;
    }

    @Override
    public Object getBean(Class<?> type, Scope scope) {
        for (Object obj : beansMap.values()) {
            if (!type.isAssignableFrom(obj.getClass())) continue;
            if (null != scope && scope == Scope.PROTOTYPE) {
                try {
                    return CloneKit.deepClone((Object)obj);
                }
                catch (Exception e) {
                    LOGGER.error((Object)("\u514b\u9686\u5bf9\u8c61\u5931\u8d25," + e.getMessage()));
                    continue;
                }
            }
            return obj;
        }
        return null;
    }

    @Override
    public Set<String> getBeanNames() {
        return beansMap.keySet();
    }

    @Override
    public Collection<Object> getBeans() {
        return beansMap.values();
    }

    @Override
    public boolean hasBean(Class<?> clz) {
        return null != this.getBean(clz, Scope.SINGLE);
    }

    @Override
    public boolean hasBean(String name) {
        return null != this.getBean(name, Scope.SINGLE);
    }

    @Override
    public boolean removeBean(String name) {
        Object object = beansMap.remove(name);
        return null != object;
    }

    @Override
    public boolean removeBean(Class<?> clazz) {
        Object object = beansMap.remove(clazz.getName());
        return null != object;
    }

    @Override
    public Object registBean(Class<?> clazz) {
        String name = clazz.getCanonicalName();
        Object object = null;
        if (!Modifier.isAbstract(clazz.getModifiers()) && !clazz.isInterface()) {
            object = ReflectKit.newInstance(clazz);
            this.put(name, object);
            if (clazz.getInterfaces().length > 0) {
                this.put(clazz.getInterfaces()[0].getCanonicalName(), object);
            }
            if (null != clazz.getDeclaredAnnotations()) {
                this.putAnnotationMap(clazz, object);
            }
        }
        return object;
    }

    private void put(String name, Object object) {
        if (null == beansMap.get(name)) {
            beansMap.put(name, object);
        }
    }

    private void putAnnotationMap(Class<?> clazz, Object object) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = clazz.getAnnotations()) {
            if (null == annotation) continue;
            ArrayList listObject = annotationMap.get(annotation.annotationType());
            if (CollectionKit.isEmpty(listObject)) {
                listObject = CollectionKit.newArrayList();
            }
            listObject.add(object);
            this.put(annotation.annotationType(), listObject);
        }
    }

    private void put(Class<? extends Annotation> clazz, List<Object> listObject) {
        if (null == annotationMap.get(clazz)) {
            annotationMap.put(clazz, listObject);
        }
    }

    @Override
    public void initWired() {
        Iterator<Object> it = beansMap.values().iterator();
        try {
            while (it.hasNext()) {
                Field[] fields;
                Object obj = it.next();
                for (Field field : fields = obj.getClass().getDeclaredFields()) {
                    Inject inject = field.getAnnotation(Inject.class);
                    if (null == inject) continue;
                    Object injectField = this.getBean(field.getType(), Scope.SINGLE);
                    if (inject.value() != Class.class) {
                        injectField = this.getBean(inject.value(), Scope.SINGLE);
                        if (null == injectField) {
                            injectField = this.registBean(inject.value());
                        }
                    } else if (null == injectField) {
                        injectField = this.registBean(field.getType());
                    }
                    if (null == injectField) {
                        throw new RuntimeException("Unable to load " + field.getType().getCanonicalName() + "\uff01");
                    }
                    boolean accessible = field.isAccessible();
                    field.setAccessible(true);
                    field.set(obj, injectField);
                    field.setAccessible(accessible);
                }
            }
        }
        catch (SecurityException e) {
            LOGGER.error((Object)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)e.getMessage());
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)e.getMessage());
        }
    }

    @Override
    public boolean isRegister(Annotation[] annotations) {
        if (null == annotations || annotations.length == 0) {
            return false;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Component) && !(annotation instanceof Path)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Class<?>> getClassesByAnnotation(Class<? extends Annotation> annotation) {
        List<Object> objectList = this.getBeansByAnnotation(annotation);
        if (!CollectionKit.isEmpty(objectList)) {
            ArrayList classList = CollectionKit.newArrayList((int)objectList.size());
            for (Object object : objectList) {
                classList.add(object.getClass());
            }
            return classList;
        }
        return null;
    }

    @Override
    public List<Object> getBeansByAnnotation(Class<? extends Annotation> annotation) {
        return annotationMap.get(annotation);
    }

    @Override
    public void registBean(Set<Class<?>> classes) {
        if (!CollectionKit.isEmpty(classes)) {
            for (Class<?> clazz : classes) {
                this.registBean(clazz);
            }
        }
    }

    @Override
    public Object registBean(Object object) {
        String name = object.getClass().getName();
        this.put(name, object);
        return object;
    }

    @Override
    public boolean removeAll() {
        beansMap.clear();
        annotationMap.clear();
        return true;
    }

    private static class DefaultContainerHoder {
        private static final DefaultContainer single = new DefaultContainer();

        private DefaultContainerHoder() {
        }
    }
}

