/*
 * Decompiled with CFR 0.152.
 */
package blade;

import blade.Blade;
import blade.BladeWebContext;
import blade.exception.BladeException;
import blade.ioc.Container;
import blade.ioc.DefaultContainer;
import blade.ioc.Scope;
import blade.kit.PathKit;
import blade.kit.ReflectKit;
import blade.kit.log.Logger;
import blade.render.ModelAndView;
import blade.route.DefaultRouteMatcher;
import blade.route.HttpMethod;
import blade.route.RouteMatcher;
import blade.servlet.Request;
import blade.servlet.Response;
import blade.wrapper.RequestResponseBuilder;
import blade.wrapper.RequestWrapper;
import blade.wrapper.ResponseWrapper;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestHandler {
    private static final Logger LOGGER = Logger.getLogger(RequestHandler.class);
    private static final String ACCEPT_TYPE_REQUEST_MIME_HEADER = "Accept";
    private static final String INTERNAL_ERROR = "<html><body><h2>500 Internal Error</h2></body></html>";
    private static final Container container = DefaultContainer.single();
    static DefaultRouteMatcher routeMatcher;

    private RequestHandler() {
    }

    public static RequestHandler single() {
        return RequestHandlerHolder.single;
    }

    boolean handler(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        boolean consumed;
        String method = httpRequest.getMethod();
        String uri = PathKit.getRelativePath(httpRequest);
        if (null != Blade.staticFolder() && Blade.staticFolder().length > 0 && !this.filterStaticFolder(uri)) {
            return false;
        }
        String acceptType = httpRequest.getHeader(ACCEPT_TYPE_REQUEST_MIME_HEADER);
        String bodyContent = null;
        Request request = null;
        Response response = RequestResponseBuilder.build(httpResponse);
        RequestWrapper requestWrapper = new RequestWrapper();
        ResponseWrapper responseWrapper = new ResponseWrapper(response);
        if (Blade.debug()) {
            LOGGER.debug((Object)("Request : " + method + "\t" + uri));
        }
        HttpMethod httpMethod = HttpMethod.valueOf(method);
        try {
            this.before(requestWrapper, responseWrapper, httpRequest, uri, acceptType);
            RouteMatcher match = routeMatcher.findRouteMatcher(httpMethod, uri, acceptType);
            if (match != null) {
                Class<?> target = match.getTarget();
                Object targetObject = container.getBean(target, Scope.SINGLE);
                Method execMethod = match.getExecMethod();
                if (null != requestWrapper.getDelegate()) {
                    request = requestWrapper.getDelegate();
                    request.initRequest(match);
                } else {
                    request = RequestResponseBuilder.build(match, httpRequest);
                }
                requestWrapper.setDelegate(request);
                BladeWebContext.put(requestWrapper, responseWrapper);
                Object result = this.executeMethod(targetObject, execMethod, requestWrapper, responseWrapper);
                this.after(requestWrapper, responseWrapper, httpRequest, uri, acceptType);
                if (null != result) {
                    this.render(responseWrapper, result);
                }
                return true;
            }
            response.render404(uri);
        }
        catch (BladeException bex) {
            LOGGER.error((Object)bex.getMessage());
            httpResponse.setStatus(500);
            bodyContent = bex.getMessage() != null ? bex.getMessage() : INTERNAL_ERROR;
        }
        boolean bl = consumed = bodyContent != null;
        if (consumed && !httpResponse.isCommitted()) {
            response.render500(bodyContent);
            return true;
        }
        return false;
    }

    private void before(RequestWrapper requestWrapper, ResponseWrapper responseWrapper, HttpServletRequest httpRequest, String uri, String acceptType) {
        List<RouteMatcher> matchSet = routeMatcher.findInterceptor(HttpMethod.BEFORE, uri, acceptType);
        for (RouteMatcher filterMatch : matchSet) {
            Class<?> target = filterMatch.getTarget();
            Object targetObject = container.getBean(target, Scope.SINGLE);
            Method execMethod = filterMatch.getExecMethod();
            Request request = RequestResponseBuilder.build(filterMatch, httpRequest);
            requestWrapper.setDelegate(request);
            this.executeMethod(targetObject, execMethod, requestWrapper, responseWrapper);
        }
    }

    private String after(RequestWrapper requestWrapper, ResponseWrapper responseWrapper, HttpServletRequest httpRequest, String uri, String acceptType) {
        List<RouteMatcher> matchSet = routeMatcher.findInterceptor(HttpMethod.AFTER, uri, acceptType);
        String bodyContent = null;
        for (RouteMatcher filterMatch : matchSet) {
            Class<?> target = filterMatch.getTarget();
            Object targetObject = container.getBean(target, Scope.SINGLE);
            Method execMethod = filterMatch.getExecMethod();
            if (requestWrapper.getDelegate() == null) {
                Request request = RequestResponseBuilder.build(filterMatch, httpRequest);
                requestWrapper.setDelegate(request);
            } else {
                requestWrapper.initRequest(filterMatch);
            }
            this.executeMethod(targetObject, execMethod, requestWrapper, responseWrapper);
            String bodyAfterFilter = responseWrapper.getDelegate().body();
            if (bodyAfterFilter == null) continue;
            bodyContent = bodyAfterFilter;
        }
        return bodyContent;
    }

    private Object[] getArgs(Request request, Response response, Class<?>[] params) {
        int len = params.length;
        Object[] args = new Object[len];
        for (int i = 0; i < len; ++i) {
            Class<?> paramTypeClazz = params[i];
            if (paramTypeClazz.getName().equals(Request.class.getName())) {
                args[i] = request;
            }
            if (!paramTypeClazz.getName().equals(Response.class.getName())) continue;
            args[i] = response;
        }
        return args;
    }

    private Object executeMethod(Object object, Method method, Request request, Response response) {
        int len = method.getParameterTypes().length;
        if (len > 0) {
            Object[] args = this.getArgs(request, response, method.getParameterTypes());
            return ReflectKit.invokeMehod((Object)object, (Method)method, (Object[])args);
        }
        return ReflectKit.invokeMehod((Object)object, (Method)method, (Object[])new Object[0]);
    }

    private Object render(Response response, Object result) {
        if (result instanceof String) {
            response.render(result.toString());
        } else if (result instanceof ModelAndView) {
            response.render((ModelAndView)result);
        }
        return null;
    }

    private boolean filterStaticFolder(String uri) {
        int len = Blade.staticFolder().length;
        for (int i = 0; i < len; ++i) {
            if (!uri.startsWith(Blade.staticFolder()[i])) continue;
            return false;
        }
        return true;
    }

    private static class RequestHandlerHolder {
        private static final RequestHandler single = new RequestHandler();

        private RequestHandlerHolder() {
        }
    }
}

