/*
 * Decompiled with CFR 0.152.
 */
package blade;

import blade.Blade;
import blade.BladeBase;
import blade.ioc.Container;
import blade.ioc.DefaultContainer;
import blade.kit.log.Logger;
import blade.kit.resource.ClassPathClassReader;
import blade.kit.resource.ClassReader;
import java.util.Set;

public final class IocApplication {
    private static final Logger LOGGER = Logger.getLogger(IocApplication.class);
    static final Container container = DefaultContainer.single();
    static final ClassReader classReader = new ClassPathClassReader();

    public static void init() {
        IocApplication.initApp();
        IocApplication.initIOC();
        container.initWired();
    }

    private static void initApp() {
        container.registBean(Blade.application());
    }

    private static void initIOC() {
        String[] iocPackages = BladeBase.packageMap.get((Object)BladeBase.PackageNames.ioc);
        if (null != iocPackages && iocPackages.length > 0) {
            for (String packageName : iocPackages) {
                IocApplication.registerBean(packageName);
            }
        }
    }

    private static void registerBean(String packageName) {
        boolean recursive = false;
        if (packageName.endsWith(".*")) {
            packageName = packageName.substring(0, packageName.length() - 2);
            recursive = true;
        }
        Set classes = classReader.getClass(packageName, recursive);
        for (Class clazz : classes) {
            if (!container.isRegister(clazz.getAnnotations())) continue;
            container.registBean(clazz);
        }
        if (Blade.debug()) {
            Set<String> beanNames = container.getBeanNames();
            for (String beanName : beanNames) {
                LOGGER.debug((Object)("Load The Class\uff1a" + beanName));
            }
        }
    }

    public static void destroy() {
        container.removeAll();
    }
}

