/*
 * Decompiled with CFR 0.152.
 */
package blade;

import blade.servlet.Request;
import blade.servlet.Response;
import blade.servlet.Session;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class BladeWebContext {
    private static ThreadLocal<Request> currentRequest = new ThreadLocal();
    private static ThreadLocal<Response> currentResponse = new ThreadLocal();
    private static ServletContext servletContext;

    private BladeWebContext() {
    }

    public static Request request() {
        return currentRequest.get();
    }

    public static HttpServletRequest servletRequest() {
        return BladeWebContext.request().servletRequest();
    }

    public static Response response() {
        return currentResponse.get();
    }

    public static HttpServletResponse servletResponse() {
        return BladeWebContext.response().servletResponse();
    }

    public static Session session() {
        return BladeWebContext.request().session();
    }

    public static void servletContext(ServletContext servletContext) {
        BladeWebContext.servletContext = servletContext;
    }

    public static ServletContext servletContext() {
        return servletContext;
    }

    public static void put(Request request, Response response) {
        currentRequest.set(request);
        currentResponse.set(response);
    }

    public static void remove() {
        currentRequest.remove();
        currentResponse.remove();
    }
}

