/*
 * Decompiled with CFR 0.152.
 */
package blade;

import blade.Blade;
import blade.BladeApplication;
import blade.BladeBase;
import blade.BladeWebContext;
import blade.IocApplication;
import blade.RequestHandler;
import blade.kit.log.Logger;
import blade.route.RouteMatcherBuilder;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BladeFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(BladeFilter.class);
    private static final String APPLCATION_CLASS = "applicationClass";

    public void init(FilterConfig filterConfig) throws ServletException {
        if (!Blade.IS_INIT) {
            BladeBase.webRoot(filterConfig.getServletContext().getRealPath("/"));
            BladeWebContext.servletContext(filterConfig.getServletContext());
            BladeApplication application = this.getApplication(filterConfig);
            application.init();
            Blade.app(application);
            RequestHandler.routeMatcher = RouteMatcherBuilder.building();
            IocApplication.init();
            application.contextInitialized(BladeWebContext.servletContext());
            LOGGER.info((Object)"blade init complete!");
            BladeBase.init();
        }
    }

    private BladeApplication getApplication(FilterConfig filterConfig) throws ServletException {
        try {
            String applicationClassName = filterConfig.getInitParameter(APPLCATION_CLASS);
            if (!BladeBase.runJetty && null != applicationClassName) {
                Class<?> applicationClass = Class.forName(applicationClassName);
                return (BladeApplication)applicationClass.newInstance();
            }
            return BladeBase.bladeApplication;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpRequest.setCharacterEncoding(BladeBase.encoding());
        httpResponse.setCharacterEncoding(BladeBase.encoding());
        boolean isHandler = RequestHandler.single().handler(httpRequest, httpResponse);
        if (!isHandler && !httpResponse.isCommitted()) {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
    }

    public void destroy() {
        IocApplication.destroy();
        LOGGER.info((Object)"blade destroy!");
    }
}

