/*
 * Decompiled with CFR 0.152.
 */
package blade;

import blade.BladeApplication;
import blade.ioc.Container;
import blade.ioc.DefaultContainer;
import blade.render.Render;
import blade.render.RenderFactory;
import blade.route.DefaultRouteMatcher;
import blade.server.BladeServer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

abstract class BladeBase {
    public static String PACKAGE_ROUTE = "route";
    protected static final String DEFAULT_ACCEPT_TYPE = "*/*";
    public static String PACKAGE_INTERCEPTOR = "interceptor";
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static boolean runJetty = false;
    private static String WEB_ROOT = "";
    protected static String ENCODING = UTF_8.toString();
    protected static String VIEW_PATH = "/WEB-INF/";
    protected static String[] STATIC_FOLDER = null;
    protected static boolean IS_INIT = false;
    protected static String VIEW_EXT = ".jsp";
    protected static BladeApplication bladeApplication;
    protected static DefaultRouteMatcher routeMatcher;
    protected static final Map<PackageNames, String[]> packageMap;
    protected static String VIEW_404;
    protected static String VIEW_500;
    protected static int PORT;
    protected static boolean DEBUG;
    private static final Container container;

    protected BladeBase() {
    }

    public static synchronized void routes(String ... pckages) {
        if (null != pckages && pckages.length > 0) {
            packageMap.put(PackageNames.route, pckages);
        }
    }

    public static synchronized void defaultRoute(String basePackage) {
        if (null != basePackage) {
            packageMap.put(PackageNames.basepackge, new String[]{basePackage});
        }
    }

    public static synchronized void interceptor(String packageName) {
        if (null != packageName && packageName.length() > 0) {
            packageMap.put(PackageNames.interceptor, new String[]{packageName});
        }
    }

    public static synchronized void ioc(String ... pckages) {
        if (null != pckages && pckages.length > 0) {
            packageMap.put(PackageNames.ioc, pckages);
        }
    }

    public static synchronized void viewEngin(Render render) {
        RenderFactory.init(render);
    }

    public static synchronized void viewPath(String viewPath) {
        if (null != viewPath && viewPath.startsWith("/")) {
            VIEW_PATH = viewPath;
        }
    }

    public static synchronized void viewExt(String viewExt) {
        if (null != viewExt && viewExt.startsWith(".")) {
            VIEW_EXT = viewExt;
        }
    }

    public static synchronized void view(String viewPath, String viewExt) {
        BladeBase.viewPath(viewPath);
        BladeBase.viewExt(viewExt);
    }

    public static synchronized void staticFolder(String ... folder) {
        STATIC_FOLDER = folder;
    }

    public static synchronized void app(Class<? extends BladeApplication> clazz) {
        try {
            bladeApplication = clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static synchronized <T> void app(BladeApplication bladeApplication) {
        BladeBase.bladeApplication = bladeApplication;
    }

    public static synchronized void view404(String view404) {
        VIEW_404 = view404;
    }

    public static synchronized void view500(String view500) {
        VIEW_500 = view500;
    }

    public static synchronized void webRoot(String webRoot) {
        WEB_ROOT = webRoot;
    }

    public static synchronized void debug(boolean isdebug) {
        DEBUG = isdebug;
    }

    public static String[] defaultRoutes() {
        return packageMap.get((Object)PackageNames.basepackge);
    }

    public static String[] routes() {
        return packageMap.get((Object)PackageNames.route);
    }

    public static String[] interceptor() {
        return packageMap.get((Object)PackageNames.interceptor);
    }

    public static String viewPath() {
        return VIEW_PATH;
    }

    public static String encoding() {
        return ENCODING;
    }

    public static String viewExt() {
        return VIEW_EXT;
    }

    public static String view404() {
        return VIEW_404;
    }

    public static String view500() {
        return VIEW_500;
    }

    public static String webRoot() {
        return WEB_ROOT;
    }

    public static boolean debug() {
        return DEBUG;
    }

    public static String[] staticFolder() {
        return STATIC_FOLDER;
    }

    public static BladeApplication application() {
        return bladeApplication;
    }

    public static synchronized void port(int port) {
        if (port > 0 && port < 65535) {
            PORT = port;
        }
    }

    public static void run(Integer port, String host, String context) {
        PORT = port;
        BladeServer.run(port, host, context);
    }

    public static void run() {
        BladeBase.run(PORT, null, null);
    }

    public static void run(String host) {
        BladeBase.run(PORT, host, null);
    }

    public static void run(Integer port) {
        BladeBase.run(port, null, null);
    }

    public static void run(Class<? extends BladeApplication> clazz, Integer port) {
        if (null != clazz) {
            BladeBase.app(clazz);
        }
        BladeBase.run(port, null, null);
    }

    public static void run(String host, Integer port) {
        BladeBase.run(port, host, null);
    }

    public static synchronized void register(Object object) {
        container.registBean(object);
    }

    static synchronized void init() {
        IS_INIT = true;
    }

    static {
        packageMap = new HashMap<PackageNames, String[]>();
        VIEW_404 = null;
        VIEW_500 = null;
        PORT = 9000;
        DEBUG = true;
        container = DefaultContainer.single();
    }

    public static enum PackageNames {
        basepackge,
        route,
        interceptor,
        ioc;

    }
}

