/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator;

import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.dynamic.datasource.enums.SeataMode;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.support.ScriptRunner;
import com.p6spy.engine.spy.P6DataSource;
import io.seata.rm.datasource.DataSourceProxy;
import io.seata.rm.datasource.xa.DataSourceProxyXA;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DefaultDataSourceCreator {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataSourceCreator.class);
    private DynamicDataSourceProperties properties;
    private List<DataSourceCreator> creators;

    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        Boolean lazy;
        DataSourceCreator dataSourceCreator = null;
        for (DataSourceCreator creator : this.creators) {
            if (!creator.support(dataSourceProperty)) continue;
            dataSourceCreator = creator;
            break;
        }
        if (dataSourceCreator == null) {
            throw new IllegalStateException("creator must not be null,please check the DataSourceCreator");
        }
        String publicKey = dataSourceProperty.getPublicKey();
        if (StringUtils.isEmpty((Object)publicKey)) {
            dataSourceProperty.setPublicKey(this.properties.getPublicKey());
        }
        if ((lazy = dataSourceProperty.getLazy()) == null) {
            dataSourceProperty.setLazy(this.properties.getLazy());
        }
        DataSource dataSource = dataSourceCreator.createDataSource(dataSourceProperty);
        this.runScrip(dataSource, dataSourceProperty);
        return this.wrapDataSource(dataSource, dataSourceProperty);
    }

    private void runScrip(DataSource dataSource, DataSourceProperty dataSourceProperty) {
        String schema = dataSourceProperty.getSchema();
        String data = dataSourceProperty.getData();
        if (StringUtils.hasText((String)schema) || StringUtils.hasText((String)data)) {
            ScriptRunner scriptRunner = new ScriptRunner(dataSourceProperty.isContinueOnError(), dataSourceProperty.getSeparator());
            if (StringUtils.hasText((String)schema)) {
                scriptRunner.runScript(dataSource, schema);
            }
            if (StringUtils.hasText((String)data)) {
                scriptRunner.runScript(dataSource, data);
            }
        }
    }

    private DataSource wrapDataSource(DataSource dataSource, DataSourceProperty dataSourceProperty) {
        String name = dataSourceProperty.getPoolName();
        DataSource targetDataSource = dataSource;
        Boolean enabledP6spy = this.properties.getP6spy() != false && dataSourceProperty.getP6spy() != false;
        if (enabledP6spy.booleanValue()) {
            targetDataSource = new P6DataSource(dataSource);
            log.debug("dynamic-datasource [{}] wrap p6spy plugin", (Object)name);
        }
        Boolean enabledSeata = this.properties.getSeata() != false && dataSourceProperty.getSeata() != false;
        SeataMode seataMode = this.properties.getSeataMode();
        if (enabledSeata.booleanValue()) {
            targetDataSource = SeataMode.XA == seataMode ? new DataSourceProxyXA(dataSource) : new DataSourceProxy(dataSource);
            log.debug("dynamic-datasource [{}] wrap seata plugin transaction mode [{}]", (Object)name, (Object)seataMode);
        }
        return new ItemDataSource(name, dataSource, targetDataSource, enabledP6spy, enabledSeata, seataMode);
    }

    public void setProperties(DynamicDataSourceProperties properties) {
        this.properties = properties;
    }

    public void setCreators(List<DataSourceCreator> creators) {
        this.creators = creators;
    }
}

