package com.baijiayun.duanxunbao.common.excel;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.WriteCellData;

import java.util.List;

public class SecondToTimeStrConvertor implements Converter<Integer> {

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public Class<?> supportJavaTypeKey() {
        return List.class;
    }


    @Override
    public WriteCellData<?> convertToExcelData(WriteConverterContext<Integer> context) {
        String timeStr = convertSecondToTimeStr(context.getValue());
        WriteCellData<String> result = new WriteCellData<>();
        result.setStringValue(timeStr);
        result.setType(CellDataTypeEnum.STRING);
        return result;
    }

    private String convertSecondToTimeStr(Integer duration) {
        if (duration == null || duration <=  0) {
            return "00分00秒";
        }

        StringBuilder sb = new StringBuilder();
        int hour = duration / 3600;
        int remainder = duration % 3600;
        int minute = remainder / 60;
        int second = remainder % 60;
        if (hour > 0) {
            sb.append(hour).append("小时");
        }
        if (minute > 0) {
            sb.append(minute).append("分钟");
        }
        if (second > 0) {
            sb.append(second).append("秒");
        }
        return sb.toString();
    }
}
