package com.baijiayun.duanxunbao.common.excel;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.baijiayun.duanxunbao.common.dto.IdAndNameDto;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2023/12/26
 */
public class IdAndNameConvertor implements Converter<IdAndNameDto> {

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public Class<?> supportJavaTypeKey() {
        return IdAndNameDto.class;
    }

    @Override
    public WriteCellData<?> convertToExcelData(WriteConverterContext<IdAndNameDto> context) {
        IdAndNameDto dto = context.getValue();
        WriteCellData<String> result = new WriteCellData<>();
        result.setStringValue(dto.getName());
        result.setType(CellDataTypeEnum.STRING);
        return result;
    }
}
