package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum ValidTypeEnum implements EnumService {
    LONG_TERM(1,"长期有效"),
    VALID_TIME(2,"自定义时长")
    ;

    private final int value;
    private final String desc;

    ValidTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, ValidTypeEnum> CACHE;
    static {
        CACHE = new HashMap<>();
        for (ValidTypeEnum item : ValidTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static ValidTypeEnum get(int value) {
        return CACHE.get(value);
    }
}
