package com.baijiayun.duanxunbao.common.enums;


import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
public enum TicketModuleEnum {
    WEWORK_INVITE("wework_invite", "企微邀请链接"),
    CAMP_SHARE("camp_share", "营期分享链接"),
    CAMP_INVITE_COURSE("camp_invite_course", "营期邀请课程链接"),
    GOODS_SHARE("goods_share", "商品分享链接"),

    COUPON_SHARE("coupon_share", "优惠券分享链接"),

    MARKET_SHARE("market_share", "营销活动分享链接"),

    DISTRIBUTE_SHARE("distribute_share", "分销推广链接"),

    SHOP_LIVE("shop_live", "店铺直播链接"),
    SHOP_CAMP_LIVE("shop_camp_live", "店铺训练营直播链接"),

    COMBINATION_ACTIVITY_SHARE("combination_activity_share", "拼团分享链接")

    ;

    private final String name;
    private final String desc;

    TicketModuleEnum(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    private static final Map<String, TicketModuleEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (TicketModuleEnum item : TicketModuleEnum.values()) {
            CACHE.put(item.getName(), item);
        }
    }

    public static TicketModuleEnum get(String name) {
        return CACHE.get(name);
    }
}
