package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum ShelfModeEnum implements EnumService {
    IMMEDIATELY(1,"立即上架"),
    CLOCKING(2,"定时上架"),
    NOT_YET(3,"暂不上架")
    ;

    private final int value;
    private final String desc;

    ShelfModeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, ShelfModeEnum> CACHE;
    static {
        CACHE = new HashMap<>();
        for (ShelfModeEnum item : ShelfModeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static ShelfModeEnum get(int value) {
        return CACHE.get(value);
    }
}
