package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum ProxyTypeEnum {
    HTTP("HTTP","http代理"),
    SOCKS("SOCKS","socks代理")
    ;

    private final String value;
    private final String desc;

    ProxyTypeEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<String, ProxyTypeEnum> CACHE;
    static {
        CACHE = new HashMap<>();
        for (ProxyTypeEnum item : ProxyTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static ProxyTypeEnum get(String value) {
        return CACHE.get(value);
    }
}
