package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;


public enum BusinessCustomerStatusEnum implements EnumService {
    NORMAL(1, "正常"),
    FORBID(2, "禁用"),
    INVALID(3, "过期");

    private int id;
    private String name;

    BusinessCustomerStatusEnum(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, BusinessCustomerStatusEnum> cache;

    static {
        cache = new HashMap<>(3);
        for (BusinessCustomerStatusEnum item : BusinessCustomerStatusEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static BusinessCustomerStatusEnum get(int status) {
        return cache.get(status);
    }
}
