package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum AssignUserRoleEnum {
    ASSIT("assit","直播助教"),
    EXAM_CORRECTOR("exam_corrector","考试批改人"),
    HOMEWORK_CORRECTOR("homework_corrector","作业批改人"),
    PRACTISE_CORRECTOR("practise_corrector","练习批改人")
            ;

    private final String value;
    private final String desc;

    AssignUserRoleEnum(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<String, AssignUserRoleEnum> CACHE;
    static {
        CACHE = new HashMap<>();
        for (AssignUserRoleEnum item : AssignUserRoleEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static AssignUserRoleEnum get(String value) {
        return CACHE.get(value);
    }
}
