package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum AddTypeEnum implements EnumService {
    CREATE(1,"新建"),
    COPY(2,"复制")
    ;

    private final int value;
    private final String desc;

    AddTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, AddTypeEnum> CACHE;
    static {
        CACHE = new HashMap<>();
        for (AddTypeEnum item : AddTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static AddTypeEnum get(int value) {
        return CACHE.get(value);
    }
}
