package com.baijiayun.duanxunbao.common.enums;


import java.util.HashMap;
import java.util.Map;

public enum AddFriendReplyModuleEnum{
    AD(1, 0,"AD"),

    WEWORK_ACQUISITION(2,1,"weworkAcquisition")
    ;

    private final int id;
    /**
     * 控制执行顺序
     **/
    private final int order;
    private final String desc;

    AddFriendReplyModuleEnum(int id, int order, String desc) {
        this.id = id;
        this.order = order;
        this.desc = desc;
    }

    public int getId() {
        return id;
    }

    public int getOrder() {
        return order;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<String, AddFriendReplyModuleEnum> cache;

    static {
        cache = new HashMap<>();
        for (AddFriendReplyModuleEnum item : AddFriendReplyModuleEnum.values()) {
            cache.put(item.getDesc(), item);
        }
    }

    public static AddFriendReplyModuleEnum get(String desc) {
        return cache.get(desc);
    }
}
