package com.baijiayun.duanxunbao.common.dto;

import lombok.Data;
import lombok.NonNull;

import java.io.Serializable;

/**
 * 这个类用于生成提供给百家云直播间的custom_str字段，其中包含customerNum 和 ticket 这两个字段，并用下划线分割。
 *
 * 例1: "abcdefg_123456"，其中 "abcdefg" 是customerNum，"123456" 是ticket
 * 例2: "_123456"，其中 "123456" 是ticket，没有customerNum。
 * 例3: "abcdefg_"，其中 "abcdefg" 是customerNum，没有ticket。
 * 例4: "_"，没有customerNum和ticket。
 * 例5: "123"，没有下划线，“123” 是 customerNum，没有ticket。
 *
 * @author yanmaoyuan
 * @date 2024/3/20
 */
@Data
public final class CustomStr implements Serializable {
    private String customerNum;
    private String ticket;

    private CustomStr () {
        // for serialize only
    }

    private CustomStr(String customerNum, String ticket) {
        this.customerNum = null;
        if (customerNum != null) {
            customerNum = customerNum.trim();
            if (!customerNum.isEmpty()) {
                this.customerNum = customerNum;
            }
        }

        this.ticket = null;
        if (ticket != null) {
            ticket = ticket.trim();
            if (!ticket.isEmpty()) {
                this.ticket = ticket;
            }
        }
    }

    @NonNull
    public static CustomStr parse(String customStr) {
        if (customStr == null) {
            return new CustomStr(null, null);
        }
        int index = customStr.indexOf('_');
        if (index < 0) {
            return new CustomStr(customStr, null);
        }
        String customerNum = customStr.substring(0, index);
        String ticket = customStr.substring(index + 1);
        return new CustomStr(customerNum, ticket);
    }
}