package com.baijiayun.duanxunbao.common.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
public class CanalKafkaData implements Serializable {

    private static final long serialVersionUID = -1L;
    /**
     * 新数据
     */
    private List<Map<String,String>> data;
    /**
     * 数据库名
     */
    private String database;
    /**
     * 表名
     */
    private String table;

    private Date es;
    /**
     * 消息ID
     */
    private Long id;
    /**
     * 是否是ddl语句
     */
    private Boolean isDdl;
    /**
     * 各字段mysql类型
     */
    private Map<String,String> mysqlType;
    /**
     * 修改的字段及原来的值
     */
    private List<Map<String,String>> old;
    /**
     * 主键
     */
    private List<String> pkNames;
    /**
     * sql
     */
    private String sql;
    /**
     * 时间戳
     */
    private Date ts;

    /**
     * 类型 如: UPDATE, INSERT, DELETE
     */
    private String type;
}