package com.baijiayun.duanxunbao.common.dto;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.io.Serializable;

@Data
@ApiModel(description = "manager基础请求参数")
public class BizIdAndUserIdReq implements Serializable {

    @JsonProperty("biz_id")
    @JsonAlias("bizId")
    @ApiModelProperty(notes = "商户ID", required = true, example = "1", hidden = true)
    private Long bizId;

    @JsonProperty("user_id")
    @JsonAlias("userId")
    @ApiModelProperty(notes = "用户ID", example = "1", hidden = true)
    private Long userId;

    public void validateBizAndUser() {
        Preconditions.checkArgument(bizId != null, "bizId is null");
        Preconditions.checkArgument(userId != null, "userId is null");
    }

    public void validateBiz() {
        Preconditions.checkArgument(bizId != null, "bizId is null");
    }
}
