/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.web.utils;

import com.baijiayun.duanxunbao.common.web.utils.CustomHttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.util.DigestUtils;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public final class SignUtils {
    private static final Logger log = LoggerFactory.getLogger(SignUtils.class);

    private SignUtils() {
    }

    public static boolean verifySign(SortedMap<String, Collection<String>> params, String headerSign) {
        if (params == null || StringUtils.isEmpty((CharSequence)headerSign)) {
            return false;
        }
        String paramsSign = SignUtils.getParamsSign(params);
        if (log.isDebugEnabled()) {
            log.debug("param Sign : {}", (Object)paramsSign);
        }
        return !StringUtils.isEmpty((CharSequence)paramsSign) && headerSign.equals(paramsSign);
    }

    public static String getParamsSignStr(SortedMap<String, Collection<String>> params) {
        ArrayList list = new ArrayList();
        params.forEach((key, values) -> {
            if (CollectionUtils.isEmpty((Collection)values)) {
                list.add(key + "=");
            } else {
                if (values.size() == 1) {
                    list.add(key + "=" + (String)values.stream().findFirst().get());
                    return;
                }
                ArrayList sortedValues = new ArrayList(values);
                sortedValues.sort(Comparator.naturalOrder());
                for (String value : sortedValues) {
                    list.add(key + "=" + value);
                }
            }
        });
        return StringUtils.join(list, (char)'&');
    }

    public static String getParamsSign(SortedMap<String, Collection<String>> params) {
        String paramsSignStr = SignUtils.getParamsSignStr(params);
        if (log.isDebugEnabled()) {
            log.debug("param sign str: {}", (Object)paramsSignStr);
        }
        return DigestUtils.md5DigestAsHex((byte[])paramsSignStr.getBytes(StandardCharsets.UTF_8)).toUpperCase(Locale.getDefault());
    }

    public static TreeMap<String, Collection<String>> getAllParams(HttpServletRequest request) throws IOException {
        TreeMap<String, Collection<String>> result = new TreeMap<String, Collection<String>>();
        if (HttpMethod.GET.name().equals(request.getMethod())) {
            result.putAll(SignUtils.getUrlParams(request));
        } else {
            result.putAll(SignUtils.getRequestBody(request));
        }
        return result;
    }

    public static Map<String, Collection<String>> getRequestBody(HttpServletRequest request) throws IOException {
        String contentType = request.getContentType();
        if (StringUtils.isNotBlank((CharSequence)contentType) && contentType.startsWith("multipart/form-data")) {
            CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver();
            MultipartHttpServletRequest multipartHttpServletRequest = multipartResolver.resolveMultipart(request);
            HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
            for (Map.Entry entry : multipartHttpServletRequest.getParameterMap().entrySet()) {
                result.put((String)entry.getKey(), (Collection<String>)Arrays.asList((Object[])entry.getValue()));
            }
            return result;
        }
        if (StringUtils.isNotBlank((CharSequence)contentType) && contentType.startsWith("application/x-www-form-urlencoded")) {
            HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
            for (Map.Entry entry : request.getParameterMap().entrySet()) {
                result.put((String)entry.getKey(), (Collection<String>)Arrays.asList((Object[])entry.getValue()));
            }
            return result;
        }
        String requestBody = SignUtils.readBodyString(request);
        return Collections.singletonMap("body", Collections.singletonList(requestBody));
    }

    public static String readBodyString(HttpServletRequest request) throws IOException {
        CustomHttpServletRequestWrapper requestWrapper;
        if (request instanceof CustomHttpServletRequestWrapper) {
            requestWrapper = (CustomHttpServletRequestWrapper)request;
        } else {
            log.info("create CustomHttpServletRequestWrapper uri:{}", (Object)request.getRequestURI());
            requestWrapper = new CustomHttpServletRequestWrapper(request);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)requestWrapper.getInputStream()));){
            int read;
            StringWriter writer = new StringWriter();
            char[] buf = new char[4096];
            while ((read = reader.read(buf)) != -1) {
                writer.write(buf, 0, read);
            }
            String string = writer.getBuffer().toString();
            return string;
        }
    }

    public static Map<String, Collection<String>> getRequestBody(byte[] body) {
        if (body == null) {
            return Collections.singletonMap("body", Collections.singletonList(""));
        }
        String requestBody = new String(body, StandardCharsets.UTF_8);
        return Collections.singletonMap("body", Collections.singletonList(requestBody));
    }

    public static Map<String, Collection<String>> getRequestBody(String contentType, byte[] body) {
        if (StringUtils.isNotBlank((CharSequence)contentType) && contentType.startsWith("multipart/form-data")) {
            return Collections.singletonMap("body", Collections.singletonList(""));
        }
        if (StringUtils.isNotBlank((CharSequence)contentType) && contentType.startsWith("application/x-www-form-urlencoded")) {
            if (body == null) {
                return Collections.emptyMap();
            }
            String formUrlencoded = new String(body, StandardCharsets.UTF_8);
            if (log.isDebugEnabled()) {
                log.debug("formUrlencoded: {}", (Object)formUrlencoded);
            }
            return SignUtils.getUrlParams(formUrlencoded);
        }
        return SignUtils.getRequestBody(body);
    }

    public static Map<String, Collection<String>> getUrlParams(HttpServletRequest request) {
        return SignUtils.getUrlParams(request.getQueryString());
    }

    public static Map<String, Collection<String>> getUrlParams(String queryString) {
        String[] params;
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>(16);
        if (StringUtils.isEmpty((CharSequence)queryString)) {
            return result;
        }
        String param = "";
        try {
            param = URLDecoder.decode(queryString, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (param.startsWith("?")) {
            param = param.substring(1);
        }
        for (String s : params = param.split("&")) {
            int index = s.indexOf(61);
            String key = s.substring(0, index);
            String value = s.substring(index + 1);
            result.computeIfAbsent(key, k -> new ArrayList()).add(value);
        }
        return result;
    }
}

