/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.web.utils;

import com.baijiayun.duanxunbao.common.dto.ResultError;
import com.baijiayun.duanxunbao.common.enums.ResultCode;
import com.baijiayun.duanxunbao.common.exception.BusinessException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(CustomHttpServletRequestWrapper.class);
    private final byte[] body;
    private final Map<String, String> headerMap;

    public CustomHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        this.body = this.readBytes((ServletRequest)request);
        this.headerMap = new HashMap<String, String>();
        if (log.isDebugEnabled()) {
            log.debug("request method:{}, uri:{}, body:{}", new Object[]{request.getMethod(), request.getRequestURI(), new String(this.body, StandardCharsets.UTF_8)});
        }
    }

    public String getHeader(String name) {
        String headerValue = super.getHeader(name);
        if (this.headerMap.containsKey(name)) {
            headerValue = this.headerMap.get(name);
        }
        return headerValue;
    }

    public Enumeration<String> getHeaders(String name) {
        List<Object> values = Collections.list(super.getHeaders(name));
        if (this.headerMap.containsKey(name)) {
            values = Collections.singletonList(this.headerMap.get(name));
        }
        return Collections.enumeration(values);
    }

    public Enumeration<String> getHeaderNames() {
        HashSet names = new HashSet();
        Enumeration e = super.getHeaderNames();
        while (e.hasMoreElements()) {
            names.add(e.nextElement());
        }
        names.addAll(this.headerMap.keySet());
        return Collections.enumeration(names);
    }

    public void addHeader(String name, String value) {
        this.headerMap.put(name, value);
    }

    public byte[] readBytes(ServletRequest request) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        try {
            int len;
            while ((len = request.getInputStream().read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, len);
            }
            byteArrayOutputStream.flush();
        }
        catch (IOException e) {
            log.error("cloneInputStream error", (Throwable)e);
            throw new BusinessException((ResultError)ResultCode.SYSTEM_ERROR);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() {
        final ByteArrayInputStream bis = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() {
                return bis.read();
            }

            public boolean isFinished() {
                return bis.available() > 0;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }
}

