/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.web.interceptor;

import com.baijiayun.duanxunbao.common.annotation.SignNeedless;
import com.baijiayun.duanxunbao.common.config.SignAuthProperties;
import com.baijiayun.duanxunbao.common.dto.Result;
import com.baijiayun.duanxunbao.common.dto.ResultError;
import com.baijiayun.duanxunbao.common.enums.ResultCode;
import com.baijiayun.duanxunbao.common.utils.JacksonUtil;
import com.baijiayun.duanxunbao.common.utils.WebCommonUtil;
import com.baijiayun.duanxunbao.common.web.utils.HandlerMethodUtils;
import com.baijiayun.duanxunbao.common.web.utils.SignUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class SignAuthInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SignAuthInterceptor.class);
    @Resource
    private SignAuthProperties signAuthProperties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!this.signAuthProperties.isEnable()) {
            if (log.isDebugEnabled()) {
                log.debug("\u8df3\u8fc7\u7b7e\u540d\u6821\u9a8c");
            }
            return true;
        }
        if (HandlerMethodUtils.hasAnnotation(handler, SignNeedless.class)) {
            if (log.isDebugEnabled()) {
                log.debug("\u63a5\u53e3\u514d\u7b7e\u540d\u6821\u9a8c, uri:{}", (Object)request.getRequestURI());
            }
            return true;
        }
        TreeMap<String, Collection<String>> allParams = SignUtils.getAllParams(request);
        String sign = request.getHeader("B-Sign");
        String timestamp = request.getHeader("B-Timestamp");
        if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{sign, timestamp})) {
            log.error("\u7b7e\u540d\u6821\u9a8c\u5931\u8d25, B-SIGN B-TIMESTAMP \u4e3a\u7a7a, uri:{}", (Object)request.getRequestURI());
            WebCommonUtil.returnMessage(response, JacksonUtil.obj2Str(Result.error((ResultError)ResultCode.USER_SIGN_ERROR)));
            return false;
        }
        allParams.put("timestamp", Collections.singletonList(timestamp));
        boolean isSigned = SignUtils.verifySign(allParams, sign);
        if (isSigned) {
            log.debug("\u7b7e\u540d\u6821\u9a8c\u901a\u8fc7, sign:{}, uri:{}", (Object)sign, (Object)request.getRequestURI());
            return true;
        }
        log.error("\u7b7e\u540d\u6821\u9a8c\u5931\u8d25, sign:{}, uri:{}", (Object)sign, (Object)request.getRequestURI());
        WebCommonUtil.returnMessage(response, JacksonUtil.obj2Str(Result.error((ResultError)ResultCode.USER_SIGN_ERROR)));
        return false;
    }
}

