/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.web.interceptor;

import com.baijiayun.duanxunbao.common.annotation.LoginNeedless;
import com.baijiayun.duanxunbao.common.dto.Result;
import com.baijiayun.duanxunbao.common.dto.ResultError;
import com.baijiayun.duanxunbao.common.enums.ResultCode;
import com.baijiayun.duanxunbao.common.utils.JacksonUtil;
import com.baijiayun.duanxunbao.common.utils.WebCommonUtil;
import com.baijiayun.duanxunbao.common.web.utils.HandlerMethodUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public abstract class AbstractAuthInterceptor<TOKEN_INFO>
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractAuthInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        Result<TOKEN_INFO> infoByToken;
        this.clear();
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        boolean loginNeedless = HandlerMethodUtils.hasAnnotation(handler, LoginNeedless.class);
        String token = request.getHeader("B-Token");
        if (StringUtils.isBlank((CharSequence)token)) {
            log.info("token is blank");
            return this.loginFailed(loginNeedless, response);
        }
        if (log.isDebugEnabled()) {
            log.debug("userAuth, token :{}", (Object)token);
        }
        if ((infoByToken = this.parseToken(token)) == null || !infoByToken.isSuccess()) {
            return this.loginFailed(loginNeedless, response);
        }
        Object data = infoByToken.getData();
        if (data == null) {
            return this.loginFailed(loginNeedless, response);
        }
        this.setCurrentTokenInfo(token, data);
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        this.clear();
    }

    public abstract Result<TOKEN_INFO> parseToken(String var1);

    public abstract void setCurrentTokenInfo(String var1, TOKEN_INFO var2);

    public abstract void clear();

    protected boolean loginFailed(boolean loginNeedless, HttpServletResponse response) {
        return this.loginFailed(loginNeedless, response, ResultCode.USER_NOT_LOGIN);
    }

    protected boolean loginFailed(boolean loginNeedless, HttpServletResponse response, ResultCode resultCode) {
        if (loginNeedless) {
            return true;
        }
        WebCommonUtil.returnMessage(response, JacksonUtil.obj2Str(Result.error((ResultError)resultCode)));
        this.clear();
        return false;
    }
}

