/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.verifycode;

import com.baijiayun.duanxunbao.common.dto.Result;
import com.baijiayun.duanxunbao.common.dto.key.RedisKeyEnum;
import com.baijiayun.duanxunbao.common.dto.verifycode.CaptchaDto;
import com.baijiayun.duanxunbao.common.dto.verifycode.CaptchaVerifyReq;
import com.baijiayun.duanxunbao.common.enums.ResultCode;
import com.baomidou.dynamic.datasource.toolkit.Base64;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class CaptchaService {
    private static final Logger log = LoggerFactory.getLogger(CaptchaService.class);
    public static final String BASE64_IMAGE_PREFIX = "data:image/jpeg;base64,";
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Autowired
    private DefaultKaptcha defaultKaptcha;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public Result<CaptchaDto> getCaptcha() throws IOException {
        log.info("getCaptcha");
        String captchaId = UUID.randomUUID().toString();
        ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();
        String captcha = this.defaultKaptcha.createText();
        BufferedImage image = this.defaultKaptcha.createImage(captcha);
        ImageIO.write((RenderedImage)image, "jpg", jpegOutputStream);
        RedisKeyEnum key = RedisKeyEnum.CAPTCHA;
        String captchaKey = key.prefixedFormat(this.redisKeyPrefix, new Object[]{captchaId});
        this.redisTemplate.opsForValue().set((Object)captchaKey, (Object)captcha, key.getExpireTime(), key.getTimeUnit());
        log.info("captcha:{}, redisKey:{}", (Object)captcha, (Object)captchaKey);
        String data = BASE64_IMAGE_PREFIX + Base64.byteArrayToBase64((byte[])jpegOutputStream.toByteArray());
        CaptchaDto captchaDto = new CaptchaDto();
        captchaDto.setCaptchaId(captchaId);
        captchaDto.setImage(data);
        log.info("getCaptcha, captchaId:{}, captcha:{}, image:{}", new Object[]{captchaId, captcha, data});
        return Result.ok((Object)captchaDto);
    }

    public Result<Void> verify(CaptchaVerifyReq params) {
        log.info("verify:{}", (Object)params);
        if (StringUtils.isBlank((CharSequence)params.getCaptchaId())) {
            return Result.error((int)ResultCode.USER_INVALID_CAPTCHA.getCode(), (String)"\u56fe\u5f62\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        if (StringUtils.isBlank((CharSequence)params.getCaptcha())) {
            return Result.error((int)ResultCode.USER_INVALID_CAPTCHA.getCode(), (String)"\u56fe\u5f62\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        RedisKeyEnum key = RedisKeyEnum.CAPTCHA;
        String captchaKey = key.prefixedFormat(this.redisKeyPrefix, new Object[]{params.getCaptchaId()});
        String challenge = (String)this.redisTemplate.opsForValue().get((Object)captchaKey);
        if (StringUtils.isBlank((CharSequence)challenge)) {
            log.info("\u6839\u636ecaptchaKey:{}\u672a\u83b7\u53d6\u5230\u7f13\u5b58\u7684\u503c", (Object)captchaKey);
            return Result.error((int)ResultCode.USER_INVALID_CAPTCHA.getCode(), (String)"\u56fe\u5f62\u9a8c\u8bc1\u7801\u5df2\u5931\u6548");
        }
        if (!params.getCaptcha().equalsIgnoreCase(challenge)) {
            log.warn("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\uff0c\u524d\u7aef\u4f20\u5165\u7684:{},\u540e\u7aef\u7f13\u5b58\u7684:{}", (Object)params.getCaptcha(), (Object)challenge);
            return Result.error((int)ResultCode.USER_INVALID_CAPTCHA.getCode(), (String)"\u56fe\u5f62\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        this.redisTemplate.delete((Object)captchaKey);
        return Result.ok();
    }
}

