/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XSSUtil {
    private static final Logger log = LoggerFactory.getLogger(XSSUtil.class);
    private static final Pattern[] PATTERNS = new Pattern[]{Pattern.compile("<script>(.*?)</script>", 2), Pattern.compile("<SCRIPT>(.*?)</SCRIPT>", 2), Pattern.compile("</script>", 2), Pattern.compile("</SCRIPT>", 2), Pattern.compile("<script(.*?)>", 42), Pattern.compile("<SCRIPT(.*?)>", 42), Pattern.compile("eval(.*?)", 42), Pattern.compile("expression(.*?)", 42), Pattern.compile("javascript:", 2), Pattern.compile("vbscript:", 2), Pattern.compile("onload(.*?)=", 42), Pattern.compile("alert(.*?)", 42), Pattern.compile("(<(script|iframe|embed|frame|frameset|object|applet|layer|ilayer|bgsound))")};

    private XSSUtil() {
    }

    public static String filterBody(String params) {
        try {
            if (StringUtils.isBlank((CharSequence)params)) {
                return params;
            }
            Map map = (Map)JSONObject.parseObject((String)params, Map.class);
            if (map.isEmpty()) {
                return params;
            }
            Iterator iterator = map.entrySet().stream().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = (Map.Entry)iterator.next();
                next.setValue(XSSUtil.filterParam(next.getValue()));
            }
            return JSON.toJSONString((Object)map);
        }
        catch (Exception e) {
            log.error("XSS\u8fc7\u6ee4\u5f02\u5e38\uff1a", (Throwable)e);
            return params;
        }
    }

    public static <T> Object filterParam(T param) {
        if (param instanceof String) {
            try {
                String value = String.valueOf(param);
                for (Pattern pattern : PATTERNS) {
                    value = pattern.matcher(value).replaceAll("");
                }
                return value;
            }
            catch (Exception e) {
                log.error("XSS\u53c2\u6570\u8fc7\u6ee4\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        return param;
    }
}

