/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import java.net.IDN;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlUtil {
    private static final Logger log = LoggerFactory.getLogger(UrlUtil.class);

    private UrlUtil() {
    }

    public static Map<String, String> getQueryParams(String url) {
        HashMap<String, String> result = new HashMap<String, String>();
        int start = url.indexOf(63);
        if (start < 0) {
            return result;
        }
        int end = url.lastIndexOf(start, 35);
        if (end < 0) {
            end = url.length();
        }
        if (start > 0) {
            String[] pairs;
            String queryString = url.substring(start + 1, end);
            for (String s : pairs = queryString.split("&")) {
                int index2 = s.indexOf(61);
                if (index2 < 0) {
                    result.put(s, "");
                    continue;
                }
                String key = s.substring(0, index2);
                String value = s.substring(index2 + 1);
                result.put(key, value);
            }
        }
        return result;
    }

    public static String combineUrl(String address, String uri) {
        if (StringUtils.isBlank((CharSequence)uri)) {
            return uri;
        }
        String trimUri = uri.trim();
        if (trimUri.startsWith("http") || StringUtils.isBlank((CharSequence)address)) {
            return trimUri;
        }
        if (!address.endsWith("/") && trimUri.charAt(0) != '/') {
            return address + '/' + trimUri;
        }
        if (address.endsWith("/") && trimUri.charAt(0) == '/') {
            return address + trimUri.substring(1);
        }
        return address + trimUri;
    }

    public static boolean isValidDomain(String domain) {
        if (StringUtils.isBlank((CharSequence)domain) || domain.length() > 255) {
            return false;
        }
        String regex = "^((?!-)[A-Za-z0-9-]{1,63}(?<!-)\\.){1,5}[A-Za-z]{2,6}$";
        return domain.matches(regex);
    }

    public static boolean isValidInternationalDomain(String domain) {
        try {
            String convertedDomain = IDN.toASCII(domain);
            return UrlUtil.isValidDomain(convertedDomain);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

