/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public final class TransactionalUtils {
    private static final Logger log = LoggerFactory.getLogger(TransactionalUtils.class);

    private TransactionalUtils() {
    }

    public static void doTransactional(final Runnable function) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    log.info("\u63d0\u4ea4\u4e8b\u52a1\u6210\u529f");
                    function.run();
                }

                public void afterCompletion(int status) {
                    if (status != 0) {
                        log.warn("\u63d0\u4ea4\u4e8b\u52a1\u5f02\u5e38\uff0c\u6570\u636e\u53ef\u80fd\u56de\u6eda");
                    }
                }
            });
        } else {
            function.run();
        }
    }

    public static <T> void doTransactional(final T param, final Consumer<T> function) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    log.info("\u63d0\u4ea4\u4e8b\u52a1\u6210\u529f, param:{}", param);
                    function.accept(param);
                }

                public void afterCompletion(int status) {
                    if (status != 0) {
                        log.warn("\u63d0\u4ea4\u4e8b\u52a1\u5f02\u5e38\uff0c\u6570\u636e\u53ef\u80fd\u56de\u6eda, param:{}", param);
                    }
                }
            });
        } else {
            function.accept(param);
        }
    }

    public static <T, U> void doTransactional(final T param1, final U param2, final BiConsumer<T, U> function) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    log.info("\u63d0\u4ea4\u4e8b\u52a1\u6210\u529f, param1:{}, param2:{}", param1, param2);
                    function.accept(param1, param2);
                }

                public void afterCompletion(int status) {
                    if (status != 0) {
                        log.warn("\u63d0\u4ea4\u4e8b\u52a1\u5f02\u5e38\uff0c\u6570\u636e\u53ef\u80fd\u56de\u6eda, param1:{}, param2:{}", param1, param2);
                    }
                }
            });
        } else {
            function.accept(param1, param2);
        }
    }
}

