/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ThreadPoolMonitorUtils {
    private static final Logger log = LoggerFactory.getLogger((String)"threadPoolMonitorLog");
    @Autowired(required=false)
    private HikariDataSource hikariDataSource;
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("ThreadPoolMonitor").build());
    private static final CopyOnWriteArrayList<ThreadPoolExecutor> THREAD_POOL_EXECUTORS = new CopyOnWriteArrayList();
    private static final Map<ThreadPoolExecutor, String> NAMES = new ConcurrentHashMap<ThreadPoolExecutor, String>();

    @PostConstruct
    public void print() {
        ThreadPoolMonitorUtils.addToMonitor("ThreadPoolMonitor", this.executorService);
        Runnable printTask = () -> {
            StringBuilder buffer = new StringBuilder(81);
            buffer.append("\u7ebf\u7a0b\u6c60\u76d1\u63a7:\n| pool status | pool size | active | queued | completed | ThreadFactory\n");
            for (ThreadPoolExecutor threadPoolExecutor : THREAD_POOL_EXECUTORS) {
                this.printThreadPoolStatus(threadPoolExecutor, buffer);
            }
            this.dataSourcePoolMonitor(buffer);
            log.info("{}", (Object)buffer);
        };
        this.executorService.scheduleWithFixedDelay(printTask, 60L, 60L, TimeUnit.SECONDS);
    }

    private void dataSourcePoolMonitor(StringBuilder buffer) {
        if (this.hikariDataSource == null) {
            return;
        }
        HikariPoolMXBean hikariPoolMXBean = this.hikariDataSource.getHikariPoolMXBean();
        if (hikariPoolMXBean == null) {
            return;
        }
        int activeConnections = hikariPoolMXBean.getActiveConnections();
        int idleConnections = hikariPoolMXBean.getIdleConnections();
        int totalConnections = hikariPoolMXBean.getTotalConnections();
        int threadsAwaitingConnection = hikariPoolMXBean.getThreadsAwaitingConnection();
        buffer.append("Hikari Pool active:").append(activeConnections).append(", idle:").append(idleConnections).append(", total:").append(totalConnections).append(", awaiting:").append(threadsAwaitingConnection);
    }

    private void printThreadPoolStatus(ThreadPoolExecutor tpe, StringBuilder buffer) {
        ThreadFactory threadFactory = tpe.getThreadFactory();
        String namePrefix = NAMES.get(tpe);
        if (StringUtils.isBlank((CharSequence)namePrefix)) {
            namePrefix = "Unknown-" + threadFactory.getClass().getSimpleName();
        }
        String terminated = tpe.isTerminated() ? "Terminated" : "Terminating";
        String status = !tpe.isShutdown() ? "Running" : terminated;
        buffer.append(String.format("| %-11s | %9d | %6d | %6d | %9d | %s%n", status, tpe.getPoolSize(), tpe.getActiveCount(), tpe.getQueue().size(), tpe.getCompletedTaskCount(), namePrefix));
    }

    public static void addToMonitor(String name, ExecutorService executorService) {
        try {
            if (executorService instanceof ThreadPoolExecutor) {
                THREAD_POOL_EXECUTORS.add((ThreadPoolExecutor)executorService);
                NAMES.put((ThreadPoolExecutor)executorService, name);
            }
        }
        catch (Exception e) {
            log.error("addToMonitor error", (Throwable)e);
        }
    }

    @PreDestroy
    public void destroy() {
        this.executorService.shutdown();
        THREAD_POOL_EXECUTORS.forEach(ThreadPoolExecutor::shutdown);
        THREAD_POOL_EXECUTORS.clear();
        log.info("monitor destroy success");
    }
}

