/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import com.baijiayun.duanxunbao.common.utils.NamedThreadFactory;
import com.baijiayun.duanxunbao.common.utils.ThreadPoolMonitorUtils;
import com.baijiayun.duanxunbao.common.utils.TraceIdUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolGroupManager {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolGroupManager.class);
    private final ConcurrentHashMap<String, PoolWrapper> poolMap = new ConcurrentHashMap();
    private final ScheduledExecutorService cleanupScheduler = Executors.newSingleThreadScheduledExecutor();
    private static final int MAX_POOL_SIZE = 100;
    private static final long THREAD_KEEP_ALIVE = 3600L;
    private static final long THREAD_POOL_EXPIRE_TIME = 7200L;
    private static final long CLEANUP_INTERVAL = 600L;
    private final String prefix;
    private final Function<String, ThreadPoolExecutor> newThreadPool;

    public ThreadPoolGroupManager() {
        this("ThreadPoolGroup");
    }

    public ThreadPoolGroupManager(String prefix) {
        this(prefix, ThreadPoolGroupManager::newThreadPoolExecutor);
    }

    public ThreadPoolGroupManager(String prefix, Function<String, ThreadPoolExecutor> newThreadPool) {
        this.prefix = prefix;
        this.newThreadPool = newThreadPool;
        this.cleanupScheduler.scheduleAtFixedRate(this::cleanupExpiredPools, 600L, 600L, TimeUnit.SECONDS);
    }

    public void execute(String groupId, Runnable task) {
        String key = groupId == null ? "default" : groupId;
        PoolWrapper wrapper = this.poolMap.compute(key, (k, v) -> {
            if (v == null || ((PoolWrapper)v).executor.isShutdown()) {
                String threadName = this.prefix + ":" + k;
                ThreadPoolExecutor executor = this.newThreadPool.apply(threadName);
                ThreadPoolMonitorUtils.addToMonitor(threadName, executor);
                return new PoolWrapper(executor);
            }
            return v;
        });
        wrapper.updateLastUsed();
        String traceId = TraceIdUtils.getTraceId();
        wrapper.executor.execute(() -> {
            TraceIdUtils.setTraceId(traceId);
            long time = System.currentTimeMillis();
            try {
                task.run();
            }
            finally {
                log.info("Thread pool task completed: {}, cost: {}ms", (Object)task, (Object)(System.currentTimeMillis() - time));
            }
        });
    }

    private static ThreadPoolExecutor newThreadPoolExecutor(String threadName) {
        return new ThreadPoolExecutor(0, 100, 3600L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(threadName), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    private void cleanupExpiredPools() {
        long now = System.currentTimeMillis();
        long expireThreshold = TimeUnit.SECONDS.toMillis(7200L);
        this.poolMap.entrySet().removeIf(entry -> {
            PoolWrapper wrapper = (PoolWrapper)entry.getValue();
            long elapsed = now - wrapper.getLastUsedTime();
            if (elapsed > expireThreshold) {
                wrapper.executor.shutdown();
                log.info("Thread pool expired: {}", entry.getKey());
                return true;
            }
            return false;
        });
    }

    public void shutdown() {
        this.cleanupScheduler.shutdown();
        this.poolMap.values().forEach(w -> ((PoolWrapper)w).executor.shutdown());
    }

    static class PoolWrapper {
        private final ThreadPoolExecutor executor;
        private final AtomicLong lastUsedTime = new AtomicLong(System.currentTimeMillis());

        PoolWrapper(ThreadPoolExecutor executor) {
            this.executor = executor;
        }

        void updateLastUsed() {
            this.lastUsedTime.set(System.currentTimeMillis());
        }

        long getLastUsedTime() {
            return this.lastUsedTime.get();
        }
    }
}

