/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import java.util.Objects;

public final class PriceUtils {
    private PriceUtils() {
    }

    public static String priceToStr(Long price, Integer scale) {
        if (Objects.isNull(price) || Objects.isNull(scale)) {
            return String.valueOf(0);
        }
        if (price == 0L || scale == 0) {
            return String.valueOf(price);
        }
        if (scale < 0) {
            throw new IllegalArgumentException("\u4fdd\u7559\u7684\u4f4d\u6570\u4e0d\u80fd\u4e3a\u4e3a\u8d1f\u6570");
        }
        double divisor = PriceUtils.getDivisor(scale);
        Double realPrice = (double)price.longValue() / divisor;
        return String.valueOf(realPrice);
    }

    public static double priceToDouble(Long price, Integer scale) {
        if (Objects.isNull(price) || Objects.isNull(scale)) {
            return 0.0;
        }
        if (price == 0L || scale == 0) {
            return price.doubleValue();
        }
        if (scale < 0) {
            throw new IllegalArgumentException("\u4fdd\u7559\u7684\u4f4d\u6570\u4e0d\u80fd\u4e3a\u4e3a\u8d1f\u6570");
        }
        return price.doubleValue() / PriceUtils.getDivisor(scale);
    }

    private static double getDivisor(Integer scale) {
        double base;
        double result = base = 10.0;
        for (int i = 1; i < scale; ++i) {
            result *= base;
        }
        return result;
    }

    public static long priceScale(Long price) {
        if (price == null || price <= 0L) {
            return 0L;
        }
        return price - price % 100L;
    }
}

