/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import com.google.common.base.Preconditions;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedThreadFactory
implements ThreadFactory {
    private static final Logger log = LoggerFactory.getLogger(NamedThreadFactory.class);
    private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public NamedThreadFactory(String factoryName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)factoryName), (Object)"factoryName is null");
        SecurityManager s = System.getSecurityManager();
        this.group = s == null ? Thread.currentThread().getThreadGroup() : s.getThreadGroup();
        this.namePrefix = factoryName + "-pool-" + POOL_NUMBER.getAndIncrement() + "-thread-";
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        t.setDaemon(true);
        t.setUncaughtExceptionHandler((t1, e) -> log.error("thread error", e));
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

