/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class MsgLock {
    private static final Logger log = LoggerFactory.getLogger(MsgLock.class);
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    public boolean locked(String msgKey, long sec) {
        String lockKey = this.redisKeyPrefix + ":" + msgKey;
        try {
            Boolean locked = this.redisTemplate.opsForValue().setIfAbsent((Object)lockKey, (Object)"", sec, TimeUnit.SECONDS);
            log.debug("locked={}, key={}", (Object)locked, (Object)lockKey);
            if (locked == null) {
                return false;
            }
            return locked;
        }
        catch (Exception e) {
            log.error("Failed lock msgKey={}", (Object)msgKey, (Object)e);
            return false;
        }
    }

    public void unlock(String msgKey) {
        String lockKey = this.redisKeyPrefix + msgKey;
        try {
            this.redisTemplate.delete((Object)lockKey);
            log.debug("unlock key={}", (Object)lockKey);
        }
        catch (Exception e) {
            log.error("Failed unlock msgKey={}", (Object)msgKey, (Object)e);
        }
    }
}

