/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JacksonUtil {
    private static final Logger log = LoggerFactory.getLogger(JacksonUtil.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private JacksonUtil() {
    }

    public static String obj2Str(Object o) {
        try {
            return MAPPER.writeValueAsString(o);
        }
        catch (IOException e) {
            log.error("obj2Str error", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static void writeObj(OutputStream out, Object value) throws IOException {
        MAPPER.writeValue(out, value);
    }

    public static <T> T str2Obj(String s, Class<T> valueType) throws IOException {
        JavaType javaType = MAPPER.constructType(valueType);
        return (T)MAPPER.readValue(s, javaType);
    }

    public static <T> T str2Obj(String s, TypeReference<T> valueType) throws IOException {
        return (T)MAPPER.readValue(s, valueType);
    }

    public static <T> List<T> str2List(String s, Class<T> valueType) throws IOException {
        JavaType javaType = MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{valueType});
        return (List)MAPPER.readValue(s, javaType);
    }

    public static <T> T readObj(InputStream in, Class<T> valueType) throws IOException {
        return (T)MAPPER.readValue(in, valueType);
    }

    public static <T> T readObj(InputStream in, JavaType valueType) throws IOException {
        return (T)MAPPER.readValue(in, valueType);
    }

    public static Map<String, Object> toMap(Object object) {
        try {
            return (Map)MAPPER.readValue(JacksonUtil.obj2Str(object), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Map<String, Object> toMap(String jsonString) {
        try {
            return JacksonUtil.str2Obj(jsonString, Map.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static {
        MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

