/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IpUtil {
    private static final Logger log = LoggerFactory.getLogger(IpUtil.class);
    private static String serverIp;

    private IpUtil() {
        throw new UnsupportedOperationException();
    }

    public static final String getServerIp() {
        return serverIp;
    }

    public static String getIP(HttpServletRequest request) {
        Predicate<String> filterFunc = str -> StringUtils.isEmpty((CharSequence)str) || "unknown".equalsIgnoreCase((String)str);
        String ip = request.getHeader("x-forwarded-for");
        if (filterFunc.test(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (filterFunc.test(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (filterFunc.test(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (filterFunc.test(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (filterFunc.test(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (filterFunc.test(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null) {
            String string = ip = ip.contains(",") ? ip.split(",")[0] : ip;
        }
        if (StringUtils.isNotEmpty((CharSequence)ip) && ip.contains(":")) {
            ip = ip.trim().replaceAll("^((?:[0-9]{1,3}[.]){3}[0-9]{1,3}).+$", "$1");
        }
        if ("0:0:0:0:0:0:0:1".equals(ip)) {
            ip = "127.0.0.1";
        }
        return ip;
    }

    static {
        try {
            serverIp = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            serverIp = "127.0.0.1";
        }
    }
}

