/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

public class IdGen {
    private static final long START_STAMP = 1600000000000L;
    private static final long SEQUENCE_BIT = 12L;
    private static final long MACHINE_BIT = 5L;
    private static final long SERVICE_BIT = 5L;
    public static final long MAX_DATACENTER_NUM = 31L;
    public static final long MAX_MACHINE_NUM = 31L;
    public static final long MAX_SEQUENCE = 4095L;
    private static final long MACHINE_LEFT = 12L;
    private static final long SERVICE_LEFT = 17L;
    private static final long TIMESTMP_LEFT = 22L;
    private long serviceId;
    private long machineId;
    private long sequence;
    private long lastStmp = -1L;
    public static final char[] B34 = "U3BDC1N6XQW0429EZHLG57FJKAYSR8MVPT".toCharArray();
    public static final char[] B62 = "rC1g6XU3kBDjoNfQnW0x4dO29EhqbaZHLG5vz7FJKAYSRuy8stMmcIVwpPlieT".toCharArray();
    public static final long[] BASE = new long[]{1L, 62L, 3844L, 238328L, 14776336L, 916132832L, 56800235584L, 3521614606208L, 218340105584896L, 13537086546263552L, 839299365868340224L};

    public IdGen(long serviceId, long machineId) {
        if (serviceId > 31L || serviceId < 0L) {
            throw new IllegalArgumentException("serviceId can't be greater than MAX_DATACENTER_NUM or less than 0");
        }
        if (machineId > 31L || machineId < 0L) {
            throw new IllegalArgumentException("machineId can't be greater than MAX_MACHINE_NUM or less than 0");
        }
        this.serviceId = serviceId;
        this.machineId = machineId;
    }

    public synchronized long nextId() {
        long currStmp = this.getNewstmp();
        if (currStmp < this.lastStmp) {
            throw new RuntimeException("Clock moved backwards.  Refusing to generate id");
        }
        if (currStmp == this.lastStmp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currStmp = this.getNextMill();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastStmp = currStmp;
        return currStmp - 1600000000000L << 22 | this.serviceId << 17 | this.machineId << 12 | this.sequence;
    }

    private long getNextMill() {
        long mill = this.getNewstmp();
        while (mill <= this.lastStmp) {
            mill = this.getNewstmp();
        }
        return mill;
    }

    private long getNewstmp() {
        return System.currentTimeMillis();
    }

    public static String base62(long num) {
        return IdGen.encode(num, B62);
    }

    public static String base34(long num) {
        return IdGen.encode(num, B34);
    }

    public static String encode(long num, char[] chars) {
        StringBuilder sb = new StringBuilder();
        int remainder = 0;
        long scale = chars.length;
        while (num > scale - 1L) {
            remainder = (int)(num % scale);
            sb.append(chars[remainder]);
            num /= scale;
        }
        sb.append(chars[(int)num]);
        String value = sb.reverse().toString();
        return value;
    }

    public static long decode(String num) {
        if (num == null || num.isEmpty()) {
            throw new IllegalArgumentException("num is blank");
        }
        if (num.length() > BASE.length) {
            throw new IllegalArgumentException("num is too large");
        }
        long result = 0L;
        block0: for (int i = num.length() - 1; i >= 0; --i) {
            char c = num.charAt(i);
            for (int j = 0; j < B62.length; ++j) {
                if (c != B62[j]) continue;
                long d = BASE[num.length() - i - 1];
                result += (long)j * d;
                continue block0;
            }
        }
        return result;
    }

    public synchronized String getNum() {
        long id = this.nextId();
        return IdGen.base62(id);
    }

    public synchronized String getNumUpper() {
        long id = this.nextId();
        return IdGen.base34(id);
    }
}

